/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.util.Objects;
import java.util.function.Supplier;

public final class LazyValue<T> {
    private volatile T value;
    private final Supplier<T> supplier;

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T getOrCompute() {
        T result = this.value;
        return result == null ? this.maybeCompute(this.supplier) : result;
    }

    private synchronized T maybeCompute(Supplier<T> supplier) {
        if (this.value == null) {
            this.value = Objects.requireNonNull(supplier.get());
        }
        return this.value;
    }
}

