/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.mule.tooling.utils.IContentReader;
import org.mule.tooling.utils.SilentRunner;

public class InMemoryFile
extends Resource
implements IFile {
    private String newCharset = Charset.defaultCharset().name();
    private IContentHandler content;

    protected InMemoryFile(IPath path, IWorkspace workspace, IContentHandler content) {
        super(path, (Workspace)workspace);
        this.content = content;
    }

    public IContentHandler getHandler() {
        return this.content;
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.content.setContent(this.content.getContent() + this.toString(source));
        monitor.done();
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        monitor.done();
    }

    public boolean exists() {
        return true;
    }

    public boolean exists(int flags, boolean checkType) {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized(int depth) {
        return true;
    }

    public String toString(final InputStream source) {
        return SilentRunner.run(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    String string = IOUtils.toString((InputStream)source, (String)InMemoryFile.this.newCharset);
                    return string;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)source);
                }
            }
        }, "");
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.content.setContent(this.content.getContent() + this.toString(source));
        monitor.done();
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        this.content.setContent(this.toString(source));
        monitor.done();
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.content.setContent(this.toString(source));
        monitor.done();
    }

    public String getCharset() throws CoreException {
        return this.newCharset;
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        return this.newCharset;
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        return this.newCharset;
    }

    public IContentDescription getContentDescription() throws CoreException {
        return new DummyContentDescription();
    }

    public InputStream getContents() throws CoreException {
        try {
            return new ByteArrayInputStream(this.content.getContent().getBytes(this.getCharset()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(this.content.getContent().getBytes());
        }
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return this.getPersistentProperties().get(key);
    }

    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        return new HashMap<QualifiedName, String>();
    }

    public InputStream getContents(boolean force) throws CoreException {
        return this.getContents();
    }

    public int getEncoding() throws CoreException {
        return 3;
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return new IFileState[0];
    }

    public void setCharset(String newCharset) throws CoreException {
        this.newCharset = newCharset;
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        this.newCharset = newCharset;
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.content.setContent(this.toString(source));
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.setCharset(source.getCharset());
        this.content.setContent(this.toString(source.getContents()));
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.content.setContent(this.toString(source));
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setCharset(source.getCharset());
        this.content.setContent(this.toString(source.getContents()));
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.delete(force, false, null);
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.delete(0, null);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.content.delete();
    }

    public int getType() {
        return 1;
    }

    public IPath getLocation() {
        File file = this.content.getContentFile();
        return file != null ? Path.fromOSString((String)file.getAbsolutePath()) : super.getLocation();
    }

    public static IFile createInMemoryFile(File file) throws IOException {
        return InMemoryFile.createInMemoryFile(file.getName(), (IContentHandler)new FileContentHandler(file), ResourcesPlugin.getWorkspace());
    }

    public static IFile createInMemoryFile(String name, IContentHandler content, IProject project) {
        IWorkspace workspace = project.getWorkspace();
        return InMemoryFile.createInMemoryFile(name, content, workspace);
    }

    public static IFile createInMemoryFile(String name, IContentHandler content, IWorkspace workspace) {
        return new InMemoryFile(Path.fromOSString((String)(FileUtils.getTempDirectoryPath() + "/" + name)), workspace, content);
    }

    private class DummyContentDescription
    implements IContentDescription {
        private DummyContentDescription() {
        }

        public String getCharset() {
            return null;
        }

        public IContentType getContentType() {
            return null;
        }

        public Object getProperty(QualifiedName key) {
            return null;
        }

        public boolean isRequested(QualifiedName key) {
            return false;
        }

        public void setProperty(QualifiedName key, Object value) {
        }
    }

    private static class FileContentHandler
    implements IContentHandler {
        private final File file;
        private String contents;

        public FileContentHandler(File file) throws IOException {
            this.file = file;
            this.contents = FileUtils.readFileToString((File)file);
        }

        @Override
        public void setContent(String content) {
            try {
                FileUtils.write((File)this.file, (CharSequence)content);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void delete() {
            FileUtils.deleteQuietly((File)this.file);
        }

        @Override
        public String getContent() {
            return this.contents;
        }

        public String toString() {
            return "FileContentHandler [file=" + String.valueOf(this.file) + "]";
        }

        @Override
        public File getContentFile() {
            return this.file;
        }
    }

    public static interface IContentHandler
    extends IContentReader {
        public void setContent(String var1);

        public File getContentFile();

        default public void delete() {
            this.setContent("");
        }
    }
}

