/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.utils.InMemoryFile;

public class InMemoryConfigurationFile
extends InMemoryFile {
    private IProject project;
    private IPath jarPath;
    private String muleConfigurationName;
    private static final String IN_JAR_SYMBOL = "!";

    protected InMemoryConfigurationFile(IPath jarPath, String muleConfigurationName, IPath composedPath, InMemoryFile.IContentHandler content, IProject project) {
        super(composedPath, project.getWorkspace(), content);
        this.jarPath = jarPath;
        this.project = project;
        this.muleConfigurationName = muleConfigurationName;
    }

    public static InMemoryConfigurationFile createInMemoryConfigurationFile(IPath jarPath, String muleConfigurationName, InMemoryFile.IContentHandler content, IProject project) {
        String jarSegment = jarPath.lastSegment();
        IPath cutPath = jarPath.removeLastSegments(1);
        IPath composedPath = cutPath.append(jarSegment + IN_JAR_SYMBOL).append(muleConfigurationName);
        return new InMemoryConfigurationFile(jarPath, muleConfigurationName, composedPath, content, project);
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public IPath getLocation() {
        return this.jarPath;
    }

    public String getConfName() {
        return this.muleConfigurationName;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.muleConfigurationName, this.jarPath, this.project);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InMemoryConfigurationFile other = (InMemoryConfigurationFile)((Object)obj);
        return Objects.equals(this.muleConfigurationName, other.muleConfigurationName) && Objects.equals(this.jarPath, other.jarPath) && Objects.equals(this.project, other.project);
    }
}

