/*
 * Decompiled with CFR 0.152.
 */
package amf.xml.internal;

import amf.core.client.common.remote.Content;
import amf.xml.internal.ContentFetcher;
import amf.xml.internal.resolver.XmlUriResolver;
import amf.xml.internal.util.ClassLoadingUtils;
import amf.xml.internal.util.XmlUtils$;
import java.io.ByteArrayInputStream;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class XmlSchemaFactory$ {
    public static XmlSchemaFactory$ MODULE$;

    static {
        new XmlSchemaFactory$();
    }

    public SchemaFactory apply(String location, ContentFetcher fetcher) {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/XML/XMLSchema/v1.1", "org.apache.xerces.jaxp.validation.XMLSchema11Factory");
        SchemaFactory factory = ClassLoadingUtils.withContextClassLoader(this.getClass().getClassLoader(), () -> SchemaFactory.newInstance("http://www.w3.org/XML/XMLSchema/v1.1"));
        factory.setFeature(XmlUtils$.MODULE$.DisallowDoctypeDeclFeature(), !XmlUtils$.MODULE$.ExpandEntities());
        factory.setResourceResolver((type, namespaceURI, publicId, systemId, baseURI) -> {
            String importLocation = new XmlUriResolver(location).resolveUri(type, namespaceURI, publicId, systemId, baseURI);
            Content content = MODULE$.fetchContentSync(fetcher, importLocation);
            return MODULE$.createXMLInput(domImplementationLS, systemId, baseURI, content);
        });
        return factory;
    }

    private LSInput createXMLInput(DOMImplementationLS domImplementationLS, String systemId, String baseURI, Content content) {
        LSInput input = domImplementationLS.createLSInput();
        input.setByteStream(new ByteArrayInputStream(content.stream().toString().getBytes()));
        input.setSystemId(systemId);
        input.setBaseURI(baseURI);
        return input;
    }

    private Content fetchContentSync(ContentFetcher fetcher, String importLocation) {
        Future<Content> eventualContent = fetcher.fetchContent(importLocation);
        Content content = (Content)Await$.MODULE$.result(eventualContent, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
        return content;
    }

    private XmlSchemaFactory$() {
        MODULE$ = this;
    }
}

