/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.sessions;

import com.mulesoft.agent.transport.sessions.WSSession;
import okhttp3.WebSocket;
import okio.ByteString;

public class OkHttpWSSession
implements WSSession {
    private volatile WebSocket webSocket;

    public OkHttpWSSession(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void sendString(String s) {
        this.webSocket.send(ByteString.of((byte[])s.getBytes()));
    }

    @Override
    public void sendBytes(byte[] s) {
        this.webSocket.send(ByteString.of((byte[])s));
    }

    @Override
    public boolean isOpen() {
        return this.webSocket != null;
    }

    @Override
    public void close() {
        try {
            this.webSocket.close(1000, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webSocket = null;
    }
}

