/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.connections;

import com.google.common.base.Stopwatch;
import com.mulesoft.agent.transport.WSNextDelayProvider;
import com.mulesoft.agent.transport.listeners.OkHttpWebSocketListener;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OkHttpWSConnectionThread
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(OkHttpWSConnectionThread.class);
    private static final Integer TIMEOUT_SECONDS = 20;
    private static final Integer MAX_TOP_DELAY_RANDOM_SECONDS = 360;
    private static final Integer MIN_TOP_DELAY_RANDOM_SECONDS = 240;
    private static final Integer INITIAL_DELAY_MILLISECONDS = 30000;
    private static final Integer VARIANCE_PERCENTAGE_FOR_CONNECTION_DELAYS = 10;
    private static final Integer DELAY_CONNECTION_IS_STILL_CONNECTING_CHECK_MILLIS = 3000;
    private WSNextDelayProvider wsNextDelayProvider;
    private Integer connectionAttempts = 0;
    private URI serverURI;
    private OkHttpClient client;
    private OkHttpWebSocketListener webSocketListener;

    OkHttpWSConnectionThread(@NotNull OkHttpClient client, @NotNull OkHttpWebSocketListener webSocketListener, URI serverURI) {
        this.client = client;
        this.webSocketListener = webSocketListener;
        this.serverURI = serverURI;
        this.wsNextDelayProvider = new WSNextDelayProvider.WSNextDelayProviderBuilder().maxBetween(MIN_TOP_DELAY_RANDOM_SECONDS, MAX_TOP_DELAY_RANDOM_SECONDS).withFixedInitialDelay(INITIAL_DELAY_MILLISECONDS).withVariancePercentage(VARIANCE_PERCENTAGE_FOR_CONNECTION_DELAYS).build();
    }

    @Override
    public void run() {
        try {
            LOGGER.info("Initializing Mule Agent WebSocket connection");
            while (!this.isConnected()) {
                Integer n = this.connectionAttempts;
                Integer n2 = this.connectionAttempts = Integer.valueOf(this.connectionAttempts + 1);
                Thread.sleep(this.wsNextDelayProvider.updateDelay().intValue());
                Stopwatch sw = Stopwatch.createStarted();
                LOGGER.debug("Mule Agent WebSocket initializer starting attempt nro. {}", (Object)this.connectionAttempts);
                Optional<WebSocket> webSocketMaybe = this.doConnect();
                while (this.isConnecting()) {
                    LOGGER.debug("Waiting until asynchronous WebSocket connection is established");
                    if (sw.elapsed(TimeUnit.SECONDS) > (long)TIMEOUT_SECONDS.intValue()) {
                        webSocketMaybe.ifPresent(WebSocket::cancel);
                        this.webSocketListener.endConnectionAttempt();
                        break;
                    }
                    Thread.sleep(DELAY_CONNECTION_IS_STILL_CONNECTING_CHECK_MILLIS.intValue());
                }
                LOGGER.debug("Mule Agent WebSocket initializer attempt nro. {}, took: {} ms", (Object)this.connectionAttempts, (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
            LOGGER.info("Mule Agent WebSocket connection was initialized after: {} attempts", (Object)this.connectionAttempts);
        }
        catch (InterruptedException e) {
            LOGGER.error("Mule Agent WebSocket initializer was interrupted: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            LOGGER.error("Mule Agent WebSocket initializer was stopped due to an error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
            LOGGER.debug((Object)t);
        }
    }

    private Optional<WebSocket> doConnect() {
        try {
            LOGGER.info("Mule Agent WebSocket connecting to host: {}", (Object)this.serverURI.getHost());
            Request request = new Request.Builder().url(this.serverURI.toString()).build();
            WebSocket webSocket = this.client.newWebSocket(request, (WebSocketListener)this.webSocketListener);
            this.webSocketListener.startConnectionAttempt();
            return Optional.of(webSocket);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed attempt to connect nro. %d to the web socket client at %s: %s", this.connectionAttempts, this.serverURI.getHost(), ExceptionUtils.getRootCauseMessage((Throwable)e)));
            LOGGER.debug((Object)e);
            return Optional.empty();
        }
    }

    private boolean isConnected() {
        return this.webSocketListener.isSessionOpen();
    }

    private boolean isConnecting() {
        return this.webSocketListener.isConnectionAttemptInProgress();
    }
}

