/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.connections;

import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.transport.connections.OkHttpWSConnectionThread;
import com.mulesoft.agent.transport.connections.WSConnection;
import com.mulesoft.agent.transport.listeners.OkHttpWebSocketListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OkHttpWSConnection
implements WSConnection {
    private static final Logger LOGGER = LogManager.getLogger(OkHttpWSConnection.class);
    private static final long CLOSE_TIMEOUT = 10L;
    private ExecutorService executorService;
    private Future future;
    private OkHttpClient client;
    private OkHttpWebSocketListener webSocketListener;

    public OkHttpWSConnection(@NotNull OkHttpClient client, @NotNull OkHttpWebSocketListener webSocketListener) {
        this.client = client;
        this.webSocketListener = webSocketListener;
    }

    @Override
    public synchronized void connect(URI serverURI, AdministrationService administrationService) {
        if (this.webSocketListener.isConnectionAttemptInProgress()) {
            LOGGER.debug("Connection attempt is discarded. An asynchronous connection attempt is already in progress");
            return;
        }
        if (!(this.executorService != null && this.executorService.isShutdown() || this.future != null && !this.future.isCancelled() && !this.future.isDone())) {
            String serverURIWithCorrectProtocol = serverURI.toString().replace("wss://", "https://");
            try {
                this.scheduleConnection(new URI(serverURIWithCorrectProtocol));
            }
            catch (URISyntaxException e) {
                LOGGER.error("The original URI {} couldn't be transformed to the URI {}", (Object)serverURI, (Object)serverURIWithCorrectProtocol, (Object)e);
            }
        }
    }

    @Override
    public synchronized void close() {
        this.executorService.shutdown();
        this.client.dispatcher().executorService().shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            this.client.dispatcher().executorService().awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timeout elapsed waiting for the WSConnection to close.", (Throwable)e);
        }
    }

    private void scheduleConnection(@NotNull URI serverURI) {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        this.future = this.executorService.submit(new OkHttpWSConnectionThread(this.client, this.webSocketListener, serverURI));
    }
}

