/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.connections;

import com.google.common.base.Stopwatch;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.transport.WSNextDelayProvider;
import com.mulesoft.agent.transport.listeners.AsyncHttpWebSocketListener;
import com.mulesoft.agent.util.TrafficInspectionUtil;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.net.URI;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.util.HttpConstants;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;

public class AsyncHttpWSConnectionThread
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(AsyncHttpWSConnectionThread.class);
    private static final Integer TIMEOUT = 15;
    private static final Integer MAX_TOP_DELAY_RANDOM_SECONDS = 360;
    private static final Integer MIN_TOP_DELAY_RANDOM_SECONDS = 240;
    private static final Integer INITIAL_DELAY_MILLISECONDS = 30000;
    private static final Integer VARIANCE_PERCENTAGE_FOR_CONNECTION_DELAYS = 10;
    private WSNextDelayProvider wsNextDelayProvider;
    private Integer connectionAttempts = 0;
    private URI serverURI;
    private AsyncHttpClient client;
    private AsyncHttpWebSocketListener webSocketListener;
    private AdministrationService administrationService;
    private ProxyAuthConfiguration proxyAuthConfiguration;

    AsyncHttpWSConnectionThread(@NotNull AsyncHttpClient client, @NotNull AsyncHttpWebSocketListener webSocketListener, URI serverURI, AdministrationService administrationService, ProxyAuthConfiguration proxyAuthConfiguration) {
        this.client = client;
        this.webSocketListener = webSocketListener;
        this.serverURI = serverURI;
        this.administrationService = administrationService;
        this.proxyAuthConfiguration = proxyAuthConfiguration;
        this.wsNextDelayProvider = new WSNextDelayProvider.WSNextDelayProviderBuilder().maxBetween(MIN_TOP_DELAY_RANDOM_SECONDS, MAX_TOP_DELAY_RANDOM_SECONDS).withFixedInitialDelay(INITIAL_DELAY_MILLISECONDS).withVariancePercentage(VARIANCE_PERCENTAGE_FOR_CONNECTION_DELAYS).build();
    }

    @Override
    public void run() {
        try {
            LOGGER.info("Initializing Mule Agent WebSocket connection");
            while (!this.isConnected()) {
                Integer n = this.connectionAttempts;
                Integer n2 = this.connectionAttempts = Integer.valueOf(this.connectionAttempts + 1);
                Stopwatch sw = Stopwatch.createStarted();
                LOGGER.debug("Mule Agent WebSocket initializer starting attempt nro. {}", (Object)this.connectionAttempts);
                Thread.sleep(this.wsNextDelayProvider.updateDelay().intValue());
                this.doConnect();
                LOGGER.debug("Mule Agent WebSocket initializer attempt nro. {}, took: {} ms", (Object)this.connectionAttempts, (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
            LOGGER.info("Mule Agent WebSocket connection was initialized after: {} attempts", (Object)this.connectionAttempts);
        }
        catch (InterruptedException e) {
            LOGGER.error("Mule Agent WebSocket initializer was interrupted: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug((Object)e);
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            LOGGER.error("Mule Agent WebSocket initializer was stopped due to an error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
            LOGGER.debug((Object)t);
        }
    }

    private void doConnect() {
        try {
            LOGGER.info("Mule Agent WebSocket connecting to host: {}", (Object)this.serverURI.getHost());
            WebSocketUpgradeHandler handler = new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)this.webSocketListener).build();
            RequestBuilder requestBuilder = (RequestBuilder)new RequestBuilder(HttpConstants.Methods.GET).setUrl(this.serverURI.toString());
            if (this.proxyAuthConfiguration != null && this.proxyAuthConfiguration.isTrafficInspectionEnabled()) {
                LOGGER.info("Traffic inspection is enabled - Creating and Signing JWT");
                String jwt = TrafficInspectionUtil.generateAndSignJWT((Key)this.administrationService.getMulePrivateKey(), (Certificate[])this.administrationService.getMuleCertChain(), (String)this.administrationService.getMuleServerId());
                requestBuilder.setHeader((CharSequence)"Authorization", "Bearer " + jwt);
            }
            Request request = requestBuilder.build();
            ListenableFuture futureConnection = this.client.prepareRequest(request).execute((AsyncHandler)handler);
            futureConnection.get(TIMEOUT.intValue(), TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            LOGGER.info(String.format("Failed attempt to connect nro. %d to the web socket client at %s: Connection refused.", this.connectionAttempts, this.serverURI.getHost()));
            LOGGER.debug((Object)e);
        }
        catch (TimeoutException e) {
            LOGGER.info(String.format("Failed attempt to connect nro. %d to the web socket client at %s: The server is not responding. This could be happening because the server is not started or the port number is wrong.", this.connectionAttempts, this.serverURI.getHost()));
        }
        catch (Exception e) {
            LOGGER.info(String.format("Failed attempt to connect nro. %d to the web socket client at %s: %s", this.connectionAttempts, this.serverURI.getHost(), ExceptionUtils.getRootCauseMessage((Throwable)e)));
            LOGGER.debug((Object)e);
        }
    }

    private boolean isConnected() {
        return this.webSocketListener.isSessionOpen();
    }
}

