/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.connections;

import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.transport.connections.AsyncHttpWSConnectionThread;
import com.mulesoft.agent.transport.connections.WSConnection;
import com.mulesoft.agent.transport.listeners.AsyncHttpWebSocketListener;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;

public class AsyncHttpWSConnection
implements WSConnection {
    private static final Logger LOGGER = LogManager.getLogger(AsyncHttpWSConnection.class);
    private static final long CLOSE_TIMEOUT = 10L;
    private ExecutorService executorService;
    private AsyncHttpClient client;
    private Future future;
    private AsyncHttpWebSocketListener webSocketListener;
    private ProxyAuthConfiguration proxyAuthConfiguration = null;

    public AsyncHttpWSConnection(@NotNull AsyncHttpClient client, @NotNull AsyncHttpWebSocketListener webSocketListener, ProxyAuthConfiguration proxyAuthConfiguration) {
        this.client = client;
        this.webSocketListener = webSocketListener;
        this.proxyAuthConfiguration = proxyAuthConfiguration;
    }

    @Override
    public synchronized void connect(URI serverURI, AdministrationService administrationService) {
        if (!(this.executorService != null && this.executorService.isShutdown() || this.future != null && !this.future.isCancelled() && !this.future.isDone())) {
            this.scheduleConnection(serverURI, administrationService);
        }
    }

    @Override
    public synchronized void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timeout elapsed waiting for the WSConnection to close.", (Throwable)e);
        }
    }

    private void scheduleConnection(@NotNull URI serverURI, AdministrationService administrationService) {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        this.future = this.executorService.submit(new AsyncHttpWSConnectionThread(this.client, this.webSocketListener, serverURI, administrationService, this.proxyAuthConfiguration));
    }
}

