/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import com.mulesoft.agent.transport.WSRandomProvider;

public class WSNextDelayProvider {
    private WSRandomProvider wsRandomProvider;
    private Integer initialDelayMilliseconds = 30000;
    private Integer maxDelayMilliseconds = 300000;
    private Integer delayMilliseconds = -1;

    protected WSNextDelayProvider() {
    }

    public WSNextDelayProvider(WSRandomProvider wsRandomProvider) {
        this.wsRandomProvider = wsRandomProvider;
    }

    public void setInitialDelayMilliseconds(Integer initialDelayMilliseconds) {
        this.initialDelayMilliseconds = initialDelayMilliseconds;
    }

    public void setMaxDelayMilliseconds(Integer maxDelayMilliseconds) {
        this.maxDelayMilliseconds = maxDelayMilliseconds;
    }

    public void setWsRandomProvider(WSRandomProvider wsRandomProvider) {
        this.wsRandomProvider = wsRandomProvider;
    }

    public Integer updateDelay() {
        if (this.delayMilliseconds == -1) {
            this.delayMilliseconds = 0;
        } else if (this.delayMilliseconds == 0) {
            this.delayMilliseconds = this.initialDelayMilliseconds;
        } else if (this.delayMilliseconds < this.maxDelayMilliseconds) {
            this.delayMilliseconds = this.delayMilliseconds * 2;
            this.delayMilliseconds = this.delayMilliseconds * this.wsRandomProvider.nextRandom() / 100;
            if (this.delayMilliseconds > this.maxDelayMilliseconds) {
                this.delayMilliseconds = this.maxDelayMilliseconds;
            }
        }
        return this.delayMilliseconds;
    }

    public static class WSNextDelayProviderBuilder {
        private WSNextDelayProvider wsNextDelayProvider = new WSNextDelayProvider();

        public WSNextDelayProviderBuilder maxBetween(Integer min, Integer max) {
            this.wsNextDelayProvider.setMaxDelayMilliseconds(new WSRandomProvider(min, max).nextRandom());
            return this;
        }

        public WSNextDelayProviderBuilder withFixedInitialDelay(Integer initialDelay) {
            this.wsNextDelayProvider.setInitialDelayMilliseconds(initialDelay);
            return this;
        }

        public WSNextDelayProviderBuilder withVariancePercentage(Integer variancePercentage) {
            this.wsNextDelayProvider.setWsRandomProvider(new WSRandomProvider(100 - variancePercentage, 100 + variancePercentage));
            return this;
        }

        public WSNextDelayProvider build() {
            return this.wsNextDelayProvider;
        }
    }
}

