/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import com.mulesoft.agent.security.FipsUtils;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NettySslContextBuilder {
    private static final Logger LOGGER = LogManager.getLogger(NettySslContextBuilder.class);
    protected static final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1.2"};
    private SSLContext sslContext;
    private boolean isClient = true;
    private ApplicationProtocolConfig apn = null;
    private boolean startTls = false;
    private ClientAuth clientAuth = ClientAuth.REQUIRE;
    private IdentityCipherSuiteFilter identityCipherSuiteFilter = IdentityCipherSuiteFilter.INSTANCE;
    private static final String CONFIGURATION_FOLDER_PROPERTY = "mule.agent.configuration.folder";
    private static final String TLS_DEFAULT_CONF = "tls-default.conf";
    private static final String TLS_FIPS_CONF = "tls-fips140-2.conf";
    private static final String CIPHER_SUITES = "enabledCipherSuites";

    private NettySslContextBuilder(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public static NettySslContextBuilder newInstance(SSLContext sslContext) {
        return new NettySslContextBuilder(sslContext);
    }

    private Properties getTlsConfigFromConfDir(String fileName) {
        String confFolder = System.getProperty(CONFIGURATION_FOLDER_PROPERTY);
        String tlsConfigPath = confFolder + File.separator + fileName;
        File tlsDefaultFile = new File(tlsConfigPath);
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(tlsDefaultFile);){
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public SslContext build() {
        String ciphers;
        SSLServerSocketFactory ssf = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        Set supportedCiphers = Stream.of(ssf.getSupportedCipherSuites()).collect(Collectors.toSet());
        Properties prop = FipsUtils.isFipsEnabled() ? this.getTlsConfigFromConfDir(TLS_FIPS_CONF) : this.getTlsConfigFromConfDir(TLS_DEFAULT_CONF);
        if (prop.get(CIPHER_SUITES) != null && (ciphers = (String)prop.get(CIPHER_SUITES)) != null) {
            supportedCiphers = Arrays.stream(ciphers.split(",")).map(String::trim).collect(Collectors.toSet());
        }
        LOGGER.info("Supported ciphers: {}  protocols: {} ", supportedCiphers, (Object)SUPPORTED_PROTOCOLS);
        return new JdkSslContext(this.sslContext, this.isClient, supportedCiphers, (CipherSuiteFilter)this.identityCipherSuiteFilter, this.apn, this.clientAuth, SUPPORTED_PROTOCOLS, this.startTls);
    }

    protected SSLContext getSslContext() {
        return this.sslContext;
    }

    protected boolean isClient() {
        return this.isClient;
    }

    protected ApplicationProtocolConfig getApn() {
        return this.apn;
    }

    protected boolean isStartTls() {
        return this.startTls;
    }

    protected ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public IdentityCipherSuiteFilter getIdentityCipherSuiteFilter() {
        return this.identityCipherSuiteFilter;
    }
}

