/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.parsers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.message.internal.MessageBodyFactory;

public class HttpBodyParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private MessageBodyFactory messageBodyFactory;

    public HttpBodyParser(Object messageBodyFactory) {
        this.messageBodyFactory = (MessageBodyFactory)messageBodyFactory;
    }

    public <T> T parse(InputStream is, String contentType, Class<T> type) {
        MediaType mediaType = MediaType.valueOf((String)contentType);
        Map readers = this.messageBodyFactory.getReaders(mediaType);
        List messageBodyReaders = new ArrayList((Collection)readers.get(MediaType.WILDCARD_TYPE));
        List messageBodyReaders1 = (List)readers.get(mediaType);
        if (messageBodyReaders1 != null) {
            messageBodyReaders = (List)readers.get(messageBodyReaders1);
        }
        if (messageBodyReaders != null && !messageBodyReaders.isEmpty()) {
            for (MessageBodyReader reader : messageBodyReaders) {
                if (!reader.isReadable(type, type, new Annotation[0], mediaType)) continue;
                try {
                    return (T)reader.readFrom(type, type, new Annotation[0], mediaType, null, is);
                }
                catch (IOException e) {
                    LOGGER.info("Error reading class '{}' from contentType '{}' with reader '{}'. Error: {}.", type, (Object)contentType, (Object)reader, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOGGER.debug((Object)e);
                }
            }
        }
        return null;
    }

    public InputStream toInputStream(Object body, String contentType) throws IOException {
        if (body instanceof InputStream) {
            return (InputStream)body;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Class<?> type = body.getClass();
        MediaType mediaType = MediaType.valueOf((String)contentType);
        Map writers = this.messageBodyFactory.getWriters(mediaType);
        ArrayList messageBodyWriters = new ArrayList((Collection)writers.get(MediaType.WILDCARD_TYPE));
        List messageBodyWriters1 = (List)writers.get(mediaType);
        if (messageBodyWriters1 != null) {
            messageBodyWriters.addAll(messageBodyWriters1);
        }
        if (messageBodyWriters != null && !messageBodyWriters.isEmpty()) {
            for (MessageBodyWriter reader : messageBodyWriters) {
                if (!reader.isWriteable(type, type, new Annotation[0], mediaType)) continue;
                try {
                    reader.writeTo(body, type, type, new Annotation[0], mediaType, null, (OutputStream)out);
                    out.flush();
                    out.close();
                    return new ByteArrayInputStream(out.toByteArray());
                }
                catch (IOException e) {
                    LOGGER.info("Error converting to ByteArrayInputStream '{}' to contentType '{}' with reader '{}'. Error: {}.", body, (Object)contentType, (Object)reader, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOGGER.debug((Object)e);
                }
            }
        }
        return null;
    }
}

