/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.dispatch;

import com.mulesoft.agent.dispatch.AgentHttpRequest;
import com.mulesoft.agent.dispatch.AgentHttpResponse;
import com.mulesoft.agent.dispatch.DispatcherInitialisationException;
import com.mulesoft.agent.dispatch.WSRequestParser;
import com.mulesoft.agent.jackson.AllowUnknownPropertiesContextResolver;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class RestDispatcher {
    public static final String SERVLET_PATH = "http://localhost:8080/";
    private ServletContainer servletContainer;
    private Collection<Object> restCallHandlers;

    public void init() throws DispatcherInitialisationException {
        ResourceConfig resourceConfig = ResourceConfig.forApplication((Application)new Application(){

            public Set<Class<?>> getClasses() {
                return new HashSet();
            }

            public Set<Object> getSingletons() {
                return new HashSet<Object>(RestDispatcher.this.restCallHandlers);
            }
        });
        resourceConfig.packages(new String[]{"org.glassfish.jersey.examples.multipart"});
        resourceConfig.register(AllowUnknownPropertiesContextResolver.class);
        resourceConfig.register(MultiPartFeature.class);
        this.servletContainer = new ServletContainer(resourceConfig);
        try {
            this.servletContainer.init((ServletConfig)new RestDispatcherServletConfig());
        }
        catch (ServletException e) {
            throw new DispatcherInitialisationException(e);
        }
    }

    public void start() throws ServletException {
    }

    public AgentHttpResponse dispatch(HttpServletRequest request) throws Exception {
        AgentHttpResponse response = new AgentHttpResponse();
        Value statusCode = this.servletContainer.service(URI.create(SERVLET_PATH), URI.create(SERVLET_PATH + request.getPathInfo()), request, (HttpServletResponse)response);
        response.setStatus(((Integer)statusCode.get()).intValue());
        return response;
    }

    public String dispatch(String data) throws Exception {
        WSRequestParser wsRequestParser = new WSRequestParser(data);
        AgentHttpRequest httpServletRequest = wsRequestParser.parse();
        AgentHttpResponse response = new AgentHttpResponse();
        this.servletContainer.service(URI.create(SERVLET_PATH), URI.create(SERVLET_PATH + httpServletRequest.getPathInfo()), (HttpServletRequest)httpServletRequest, (HttpServletResponse)response);
        return response.asString();
    }

    public Object getMessageBodyFactory() {
        InjectionManager im = this.servletContainer.getApplicationHandler().getInjectionManager();
        MessageBodyFactory messageBodyFactory = new MessageBodyFactory(null);
        messageBodyFactory.initialize(im);
        return messageBodyFactory;
    }

    public void addRestListeners(Collection<Object> restCallHandlers) {
        this.restCallHandlers = restCallHandlers;
    }

    private class RestDispatcherServletConfig
    implements ServletConfig {
        private final Map<String, String> initParameters = new HashMap<String, String>(){
            {
                this.put("jersey.config.server.provider.classnames", "org.glassfish.jersey.filter.LoggingFilter;org.glassfish.jersey.media.multipart.MultiPartFeature");
            }
        };

        private RestDispatcherServletConfig() {
        }

        public String getServletName() {
            return "servlet-dispatcher";
        }

        public ServletContext getServletContext() {
            ServletContextHandler servletContextHandler = new ServletContextHandler();
            return servletContextHandler.getServletContext();
        }

        public String getInitParameter(String name) {
            return this.initParameters.get(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return new Vector<String>(this.initParameters.keySet()).elements();
        }
    }
}

