/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.artifact.value;

import com.google.common.base.Throwables;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.api.tooling.valueprovider.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.ExtensionResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.DefaultValueProviderMediator;
import org.mule.runtime.module.tooling.internal.artifact.AbstractParameterResolverExecutor;
import org.mule.runtime.module.tooling.internal.artifact.params.ExpressionNotSupportedException;
import org.mule.runtime.module.tooling.internal.artifact.sampledata.SampleDataExecutor;
import org.mule.runtime.module.tooling.internal.utils.ArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueProviderExecutor
extends AbstractParameterResolverExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDataExecutor.class);
    private final ConnectionManager connectionManager;

    public ValueProviderExecutor(MuleContext muleContext, ConnectionManager connectionManager, ExtendedExpressionManager expressionManager, ReflectionCache reflectionCache, ArtifactHelper artifactHelper) {
        super(muleContext, expressionManager, reflectionCache, artifactHelper);
        this.connectionManager = connectionManager;
    }

    public ValueResult resolveValues(ParameterizedModel parameterizedModel, ParameterizedElementDeclaration parameterizedElementDeclaration, String providerName) {
        return this.resolveValues(parameterizedModel, parameterizedElementDeclaration, providerName, (mediator, resolver, context) -> mediator.getValues(providerName, resolver, this.connectionSupplier(context), this.configSupplier(context), (ConnectionProvider)context.getConnectionProvider().orElse(null)), "");
    }

    public ValueResult resolveFieldValues(ParameterizedModel parameterizedModel, ParameterizedElementDeclaration parameterizedElementDeclaration, String providerName, String targetSelector) {
        return this.resolveValues(parameterizedModel, parameterizedElementDeclaration, providerName, (mediator, resolver, context) -> mediator.getValues(providerName, resolver, targetSelector, this.connectionSupplier(context), this.configSupplier(context), (ConnectionProvider)context.getConnectionProvider().orElse(null)), " with targetSelector: " + targetSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ValueResult resolveValues(ParameterizedModel parameterizedModel, ParameterizedElementDeclaration parameterizedElementDeclaration, String providerName, ValueProviderFunction valueProviderFunction, String loggingSuffix) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolve value provider: {} STARTED for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
        }
        Optional<ConfigurationInstance> optionalConfigurationInstance = this.getConfigurationInstance(parameterizedModel, parameterizedElementDeclaration, providerName);
        DefaultValueProviderMediator valueProviderMediator = this.createValueProviderMediator(parameterizedModel);
        ExtensionResolvingContext context = new ExtensionResolvingContext(() -> optionalConfigurationInstance, this.connectionManager);
        ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader((ExtensionModel)this.artifactHelper.getExtensionModel((ElementDeclaration)parameterizedElementDeclaration));
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(extensionClassLoader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking connector's value provider: {} for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
        }
        ValueResult valueResult = ValueResult.resultFrom(valueProviderFunction.apply((ValueProviderMediator)valueProviderMediator, this.parameterValueResolver(parameterizedElementDeclaration, parameterizedModel), context));
        currentThread.setContextClassLoader(currentClassLoader);
        context.dispose();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
        }
        return valueResult;
        {
            catch (Throwable throwable) {
                try {
                    currentThread.setContextClassLoader(currentClassLoader);
                    context.dispose();
                    throw throwable;
                }
                catch (ValueResolvingException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(String.format("Resolve value provider has FAILED with code: %s for component: %s %s", e.getFailureCode(), parameterizedModel.getName(), loggingSuffix), (Throwable)e);
                    }
                    valueProviderMediator = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)e).withFailureCode(e.getFailureCode()).build());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
                    }
                    return valueProviderMediator;
                }
                catch (ExpressionNotSupportedException e) {
                    valueProviderMediator = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure((Throwable)new ValueResolvingException(e.getMessage(), "INVALID_PARAMETER_VALUE")).withFailureCode("INVALID_PARAMETER_VALUE").build());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
                    }
                    return valueProviderMediator;
                }
                catch (Exception e) {
                    Throwable cause;
                    block21: {
                        cause = e.getCause();
                        if (!(cause instanceof ValueResolvingException)) break block21;
                        ValueResolvingException valueResolvingException = (ValueResolvingException)cause;
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn(String.format("Resolve value provider has FAILED with code: %s for component: %s %s", valueResolvingException.getFailureCode(), parameterizedModel.getName(), loggingSuffix), cause);
                        }
                        ResolvingFailure.Builder failureBuilder = ResolvingFailure.Builder.newFailure((Throwable)cause);
                        failureBuilder.withFailureCode(valueResolvingException.getFailureCode());
                        ValueResult valueResult2 = ValueResult.resultFrom((ResolvingFailure)failureBuilder.build());
                        {
                            catch (Throwable throwable2) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
                                }
                                throw throwable2;
                            }
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Resolve value provider: {} FINISHED for component: {} {}", new Object[]{providerName, parameterizedModel.getName(), loggingSuffix});
                        }
                        return valueResult2;
                    }
                    Throwables.propagateIfPossible((Throwable)cause, MuleRuntimeException.class);
                    throw new MuleRuntimeException(cause);
                }
            }
        }
    }

    private Supplier<Object> connectionSupplier(ExtensionResolvingContext context) {
        return () -> {
            try {
                return context.getConnection().orElse(null);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Supplier<Object> configSupplier(ExtensionResolvingContext context) {
        return () -> context.getConfig().orElse(null);
    }

    private Optional<ConfigurationInstance> getConfigurationInstance(ParameterizedModel parameterizedModel, ParameterizedElementDeclaration parameterizedElementDeclaration, String providerName) throws ValueResolvingException {
        Optional<ValueProviderModel> valueProviderModelOptional;
        Optional<String> optionalConfigRef = this.getConfigRef(parameterizedElementDeclaration);
        Optional<ConfigurationInstance> optionalConfigurationInstance = optionalConfigRef.flatMap(this.artifactHelper::getConfigurationInstance);
        if (optionalConfigRef.isPresent() && (valueProviderModelOptional = this.getValueProviderModel(parameterizedModel, providerName)).isPresent() && valueProviderModelOptional.get().requiresConfiguration() && !optionalConfigurationInstance.isPresent()) {
            throw new ValueResolvingException(String.format("The provider requires a configuration but the one referenced by element declaration with name: '%s' is not present", optionalConfigRef.get()), FailureCode.COMPONENT_NOT_FOUND.getName());
        }
        return optionalConfigurationInstance;
    }

    private Optional<ValueProviderModel> getValueProviderModel(ParameterizedModel parameterizedModel, String providerName) {
        return parameterizedModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getValueProviderModel().map(vpm -> vpm.getProviderName().equals(providerName)).orElse(false)).findFirst().flatMap(parameterModel -> parameterModel.getValueProviderModel());
    }

    private DefaultValueProviderMediator createValueProviderMediator(ParameterizedModel parameterizedModel) {
        return new DefaultValueProviderMediator(parameterizedModel, () -> this.muleContext, () -> this.reflectionCache);
    }

    private Optional<String> getConfigRef(ParameterizedElementDeclaration component) {
        if (component instanceof ComponentElementDeclaration) {
            return Optional.ofNullable(((ComponentElementDeclaration)component).getConfigRef());
        }
        return Optional.empty();
    }

    @FunctionalInterface
    private static interface ValueProviderFunction {
        public Set<Value> apply(ValueProviderMediator var1, ParameterValueResolver var2, ExtensionResolvingContext var3) throws ValueResolvingException;
    }
}

