/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.artifactvalidator;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ApplicationValidationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ApplicationValidator;
import com.mulesoft.agent.services.ApplicationValidatorService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.services.artifactvalidator.ValidatorConfiguration;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.artifact.validator.service")
@Singleton
public class AgentApplicationValidatorService
extends ConfigurableAgentService
implements ApplicationValidatorService {
    private static final Logger LOGGER = LogManager.getLogger(AgentApplicationValidatorService.class);
    public static final String APPLICATION_NAME_KEY = "_APPLICATION_NAME";
    public static final String APPLICATION_PATH_KEY = "_APPLICATION_FILE_PATH";
    public static final String APPLICATION_PROPERTIES_KEY = "_APPLICATION_PROPERTIES";
    @Configurable(type=Type.DYNAMIC, value="[]")
    private ValidatorConfiguration[] validators;
    @Inject
    List<ApplicationValidator> applicationValidators;
    @Inject
    EncryptionService encryptionService;
    private Map<String, List<ApplicationValidator>> validatorsByType;

    public void enable(boolean enabled) throws AgentEnableOperationException {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return Collections.emptyList();
    }

    public void doStart() {
        LOGGER.info("Initializing Artifact Validator service");
        this.validatorsByType = this.applicationValidators.stream().collect(Collectors.groupingBy(ApplicationValidator::getType));
        LOGGER.info("Total validators loaded: {}", (Object)this.applicationValidators.size());
        if (this.applicationValidators.size() == 0) {
            return;
        }
        LOGGER.info("Validators listed by type:");
        for (Map.Entry<String, List<ApplicationValidator>> entry : this.validatorsByType.entrySet()) {
            LOGGER.info("\tType: {} Names: {}", (Object)entry.getKey(), entry.getValue().stream().map(v -> v.getName()).collect(Collectors.toList()));
        }
    }

    public void doStop() {
        LOGGER.info("Stopping HealthCheck service");
    }

    public void validate(String applicationName, URI artifactUri, Map<String, String> props) throws ApplicationValidationException, IOException {
        HashMap<String, Object> validateArgs = new HashMap<String, Object>();
        validateArgs.put(APPLICATION_NAME_KEY, applicationName);
        validateArgs.put(APPLICATION_PATH_KEY, artifactUri.getPath());
        validateArgs.put(APPLICATION_PROPERTIES_KEY, props);
        boolean validated = false;
        for (ValidatorConfiguration validatorConfig : this.validators) {
            if (!validatorConfig.isEnabled()) continue;
            List<ApplicationValidator> currentValidators = this.validatorsByType.get(validatorConfig.getType());
            if (validatorConfig.getArgs() != null && !validatorConfig.getArgs().isEmpty()) {
                validateArgs.putAll(validatorConfig.getArgs());
            }
            this.execute(validatorConfig, currentValidators, validateArgs);
            validated = true;
        }
        if (validated) {
            LOGGER.info("Application validation success for application: '{}'.", (Object)applicationName);
            return;
        }
        LOGGER.info("Application '{}' was not validated. No validators enabled found", (Object)applicationName);
    }

    private void execute(ValidatorConfiguration validatorConfig, List<ApplicationValidator> validators, Map<String, Object> validateArgs) throws IOException, ApplicationValidationException {
        if (validatorConfig.getName() == null || validatorConfig.getName().isEmpty()) {
            for (ApplicationValidator v2 : validators) {
                v2.validate(validateArgs);
            }
        } else {
            Optional<ApplicationValidator> foundValidator = validators.stream().filter(v -> v.getName().equals(validatorConfig.getName())).findAny();
            if (foundValidator.isPresent()) {
                foundValidator.get().validate(validateArgs);
            }
        }
    }
}

