/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metrics.exporter.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.metrics.exporter.api.MeterExporter;
import org.mule.runtime.metrics.exporter.api.MeterExporterFactory;
import org.mule.runtime.metrics.exporter.impl.OpenTelemetryMeterExporter;
import org.mule.runtime.metrics.exporter.impl.capturer.CapturingMeterExporterWrapper;
import org.mule.runtime.metrics.exporter.impl.optel.resources.MeterExporterConfiguratorException;
import org.mule.runtime.module.observability.configuration.KeyValueParser;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalExporterConfigurator;

public class OpenTelemetryMeterExporterFactory
implements MeterExporterFactory {
    public static final CapturingMeterExporterWrapper METER_SNIFFER_EXPORTER = new CapturingMeterExporterWrapper();
    public static final String SERVICE_NAME_IS_MANDATORY = "Service name is mandatory.";
    public static final AttributeKey<String> SERVICE_NAME_KEY = AttributeKey.stringKey((String)"service.name");
    private final String serviceName;

    public OpenTelemetryMeterExporterFactory(String serviceName) {
        Objects.requireNonNull(serviceName, SERVICE_NAME_IS_MANDATORY);
        this.serviceName = serviceName;
    }

    public MeterExporter getMeterExporter(ObservabilitySignalConfiguration configuration) {
        Resource resource = this.getResource(configuration);
        return new OpenTelemetryMeterExporter(configuration, resource);
    }

    private Resource getResource(ObservabilitySignalConfiguration configuration) {
        AttributesBuilder attributesBuilder = Attributes.builder().put(SERVICE_NAME_KEY, (Object)this.serviceName);
        String attributesString = configuration.getStringValue("mule.openTelemetry.meter.exporter.resource.attributes");
        if (attributesString != null && !attributesString.trim().isEmpty()) {
            try {
                Map attributes = KeyValueParser.parse((String)attributesString, (KeyValueParser.KeyValueType)KeyValueParser.KeyValueType.ATTRIBUTES);
                attributes.forEach((key, value) -> attributesBuilder.put(AttributeKey.stringKey((String)key), value));
            }
            catch (IllegalArgumentException e) {
                throw new MeterExporterConfiguratorException("Invalid resource attributes configuration.", e);
            }
        }
        ObservabilitySignalExporterConfigurator.forConfiguration((ObservabilitySignalConfiguration)configuration).configureAnypointMetadata(() -> "mule.openTelemetry.meter.exporter.resource.includeAnypointMetadata", anypointMetadata -> anypointMetadata.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1)));
        return Resource.getDefault().merge(Resource.create((Attributes)attributesBuilder.build()));
    }
}

