/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.services.OnOffSwitch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.graphite.jmx.internal.handler")
@Singleton
public class GraphiteMonitorPublisher
extends BufferedHandler<ArrayList<Metric>> {
    private static final Logger LOGGER = LogManager.getLogger(GraphiteMonitorPublisher.class);
    private static final long MILLIS_TO_SECS = 1000L;
    @Configurable(value="mule", description="Prefix used to identify metrics as defined in Graphite's Carbon configuration.")
    String metricPrefix;
    @Configurable(value="0.0.0.0", description="Address corresponding to Graphite's Carbon server.")
    String graphiteServer;
    @Configurable(value="2003", description="Port corresponding to Graphite's Carbon server.")
    int graphitePort;

    @Inject
    public GraphiteMonitorPublisher() {
    }

    public GraphiteMonitorPublisher(OnOffSwitch enabledSwitch) {
        this.enabledSwitch = enabledSwitch;
    }

    public boolean canHandle(@NotNull ArrayList<Metric> metrics) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush(@NotNull Collection<ArrayList<Metric>> listOfMetrics) {
        Socket graphiteConnection = null;
        OutputStreamWriter out = null;
        BufferedReader in = null;
        try {
            graphiteConnection = new Socket(this.graphiteServer, this.graphitePort);
            for (List list : listOfMetrics) {
                for (Metric metric : list) {
                    StringBuilder message = new StringBuilder();
                    message.append(this.metricPrefix);
                    message.append(".");
                    message.append(metric.getName().replaceAll("\\s", "").replace(":", ""));
                    message.append(" ");
                    message.append(metric.getValue());
                    message.append(" ");
                    message.append((int)(metric.getTimestamp() / 1000L));
                    message.append("\n");
                    out = new OutputStreamWriter(graphiteConnection.getOutputStream());
                    out.write(message.toString());
                    out.flush();
                    in = new BufferedReader(new InputStreamReader(graphiteConnection.getInputStream()));
                    LOGGER.debug("Message sent to Graphite: " + message.toString());
                }
            }
            graphiteConnection.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to establish connection to Graphite");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (graphiteConnection != null) {
                    graphiteConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

