/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.handlers;

import com.mulesoft.agent.transport.WebSocketCommunicationService;
import com.mulesoft.agent.transport.handlers.GenericWebSocketHandler;
import com.mulesoft.agent.transport.listeners.OkHttpWebSocketListener;
import com.mulesoft.agent.transport.sessions.OkHttpWSSession;
import com.mulesoft.agent.transport.sessions.WSSession;
import java.io.EOFException;
import okhttp3.Response;
import okhttp3.WebSocket;
import okio.ByteString;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OkHttpWebSocketHandler
extends OkHttpWebSocketListener {
    private static final Logger LOGGER = LogManager.getLogger(OkHttpWebSocketHandler.class);
    private GenericWebSocketHandler innerWebSocketHandler;
    private OkHttpWSSession wsSession;
    private boolean connectionAttemptInProgress = false;

    public OkHttpWebSocketHandler(WebSocketCommunicationService webSocketCommunicationService) {
        this.innerWebSocketHandler = new GenericWebSocketHandler(webSocketCommunicationService);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        OkHttpWSSession wsSession;
        this.endConnectionAttempt();
        this.wsSession = wsSession = new OkHttpWSSession(webSocket);
        this.innerWebSocketHandler.onWebSocketOpen((WSSession)this.wsSession);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.endConnectionAttempt();
        this.innerWebSocketHandler.onWebSocketClose(code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.endConnectionAttempt();
        LOGGER.info("Web Socket is closed");
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.endConnectionAttempt();
        if (t instanceof EOFException) {
            LOGGER.error("WebSocket communication was closed abnormally");
            this.innerWebSocketHandler.onWebSocketClose(1006, "Abnormal Closure");
            return;
        }
        this.innerWebSocketHandler.onWebSocketError(t);
    }

    public void onMessage(WebSocket webSocket, String data) {
        this.innerWebSocketHandler.onWebSocketMessageReceived(data);
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        byte[] data = bytes.toByteArray();
        this.innerWebSocketHandler.onWebSocketMessageReceived(data);
    }

    public boolean isSessionOpen() {
        return this.innerWebSocketHandler.isSessionOpen();
    }

    public boolean isConnectionAttemptInProgress() {
        return this.connectionAttemptInProgress;
    }

    public void startConnectionAttempt() {
        this.setConnectionAttemptInProgress(true);
    }

    public void endConnectionAttempt() {
        this.setConnectionAttemptInProgress(false);
    }

    private synchronized void setConnectionAttemptInProgress(boolean connectionAttemptInProgress) {
        this.connectionAttemptInProgress = connectionAttemptInProgress;
    }
}

