/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.handlers;

import com.mulesoft.agent.transport.WebSocketCommunicationService;
import com.mulesoft.agent.transport.sessions.WSSession;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenericWebSocketHandler {
    private static final Logger LOGGER = LogManager.getLogger(GenericWebSocketHandler.class);
    private final WebSocketCommunicationService webSocketCommunicationService;
    private static final int DELETED_MULE_CONNECTION_CODE = 3001;

    public GenericWebSocketHandler(WebSocketCommunicationService webSocketCommunicationService) {
        this.webSocketCommunicationService = webSocketCommunicationService;
    }

    public void onWebSocketOpen(WSSession wsSession) {
        LOGGER.info("Opening Mule Agent WebSocket");
        this.webSocketCommunicationService.setWSSession(wsSession);
        this.webSocketCommunicationService.createAuthorizationService();
        LOGGER.info("Mule Agent WebSocket opened");
    }

    public void onWebSocketClose(int code, String reason) {
        LOGGER.error("Closing Mule Agent WebSocket - Close Code: {} - Close Reason: {}", (Object)code, (Object)reason);
        if (code == 3001) {
            LOGGER.info("This mule has been deleted. Platform reconnection won't be attempted.");
            try {
                this.webSocketCommunicationService.stop();
                LOGGER.info("Mule Agent WebSocket closed");
                return;
            }
            catch (Exception ex) {
                LOGGER.error("Error while attempting to stop websocket session and keepalive service", (Throwable)ex);
            }
        }
        this.webSocketCommunicationService.getWsSession().close();
        this.webSocketCommunicationService.unAuthorizeCommunication();
        LOGGER.info("Mule Agent WebSocket closed");
    }

    public void onWebSocketError(Throwable t) {
        LOGGER.error("WebSocket connection error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
        LOGGER.debug("WebSocket connection error:", t);
        this.webSocketCommunicationService.unAuthorizeCommunication();
    }

    public void onWebSocketMessageReceived(byte[] payload) {
        this.webSocketCommunicationService.onMessageReceived(payload);
    }

    public void onWebSocketMessageReceived(String data) {
        this.webSocketCommunicationService.onMessageReceived(data);
    }

    public boolean isSessionOpen() {
        return this.webSocketCommunicationService.sessionIsOpen();
    }
}

