/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport.handlers;

import com.mulesoft.agent.transport.WebSocketCommunicationService;
import com.mulesoft.agent.transport.handlers.GenericWebSocketHandler;
import com.mulesoft.agent.transport.listeners.AsyncHttpWebSocketListener;
import com.mulesoft.agent.transport.sessions.AsyncHttpWSSession;
import com.mulesoft.agent.transport.sessions.WSSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.ws.WebSocket;

public class AsyncHttpWebSocketHandler
implements AsyncHttpWebSocketListener {
    private static final Logger LOGGER = LogManager.getLogger(AsyncHttpWebSocketHandler.class);
    private GenericWebSocketHandler innerWebSocketHandler;

    public AsyncHttpWebSocketHandler(WebSocketCommunicationService webSocketCommunicationService) {
        this.innerWebSocketHandler = new GenericWebSocketHandler(webSocketCommunicationService);
    }

    public void onOpen(WebSocket webSocket) {
        this.innerWebSocketHandler.onWebSocketOpen((WSSession)new AsyncHttpWSSession(webSocket));
    }

    public void onBinaryFrame(byte[] payload, boolean finalFragment, int rsv) {
        this.innerWebSocketHandler.onWebSocketMessageReceived(payload);
    }

    public void onTextFrame(String payload, boolean finalFragment, int rsv) {
        this.innerWebSocketHandler.onWebSocketMessageReceived(payload);
    }

    public void onClose(WebSocket websocket, int code, String reason) {
        this.innerWebSocketHandler.onWebSocketClose(code, reason);
    }

    public void onError(Throwable t) {
        this.innerWebSocketHandler.onWebSocketError(t);
    }

    public boolean isSessionOpen() {
        return this.innerWebSocketHandler.isSessionOpen();
    }
}

