/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.OnOffSwitch;
import com.mulesoft.agent.transport.WebSocketAgentTransport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class WebSocketInternalMessageHandler<M>
implements InternalMessageHandler<M> {
    private final transient Logger logger = LogManager.getLogger(this.getClass());
    @Configurable(value="true")
    protected boolean enabled;
    protected WebSocketAgentTransport client;
    protected OnOffSwitch enabledSwitch;

    @PostConfigure
    public void createSwitcher() {
        this.enabledSwitch = OnOffSwitch.newNullSwitch((boolean)this.enabled);
    }

    public WebSocketInternalMessageHandler(WebSocketAgentTransport transport) {
        this.client = transport;
    }

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    public boolean handle(M message) {
        if (this.client.isConnected() && this.isEnabled()) {
            return this.doHandle(message);
        }
        this.logger.debug("Skipped handling of message , handler is " + (this.isEnabled() ? "" : "not") + " enabled and client is " + (this.client.isConnected() ? "" : "not") + " connected");
        return false;
    }

    protected abstract boolean doHandle(M var1);
}

