/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import com.google.gson.Gson;
import com.mulesoft.agent.configuration.common.SecurityConfiguration;
import com.mulesoft.agent.dispatch.AgentHttpRequest;
import com.mulesoft.agent.dispatch.AgentHttpResponse;
import com.mulesoft.agent.dispatch.AgentMessage;
import com.mulesoft.agent.dispatch.DispatcherInitialisationException;
import com.mulesoft.agent.dispatch.HandshakeConfiguration;
import com.mulesoft.agent.dispatch.RestDispatcher;
import com.mulesoft.agent.dispatch.WSRequestParser;
import com.mulesoft.agent.dispatch.WSResponseParser;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.exception.AgentInitializationException;
import com.mulesoft.agent.exception.AgentStartException;
import com.mulesoft.agent.exception.AgentStopException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.parsers.HttpBodyParser;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.DomainService;
import com.mulesoft.agent.services.KeepAliveService;
import com.mulesoft.agent.services.security.AuthorizationService;
import com.mulesoft.agent.services.security.HandshakeAuthorizationService;
import com.mulesoft.agent.services.security.NullAuthorizationService;
import com.mulesoft.agent.ssl.SSLContextLoader;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.WSConnectionFactory;
import com.mulesoft.agent.transport.connections.WSConnection;
import com.mulesoft.agent.transport.sessions.WSSession;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebSocketCommunicationService {
    private static final Logger LOGGER = LogManager.getLogger(WebSocketCommunicationService.class);
    private static final int MAX_RETRY = 3;
    private static final int RETRY_WAIT_TIME = 800;
    private static final String X_ANYPNT_SERVER_ID = "X-ANYPNT-SERVER-ID";
    private static final String X_ANYPNT_CTX_ID = "X-ANYPNT-CTX-ID";
    private static final String X_ANYPNT_AGENT_VERSION = "X-ANYPNT-AGENT-VERSION";
    private static final String DISPLAYABLE_MSG_CONTENT = "Content-Type: application/json";
    private static final String CONFIG_TRACE_WS_ENABLED = "mule.agent.configuration.trace_ws";
    private static final String MESSAGE_ID_HEADER = "Message-Id";
    private static final String HTTP_PROTOCOL_VERSION = "HTTP/1.1";
    private String serverId;
    private String contextId;
    private String agentVersion;
    private AtomicBoolean muleStarted = new AtomicBoolean(false);
    private HttpBodyParser parser;
    private boolean enabled;
    private boolean isTraceWSEnabled;
    private SecurityConfiguration security;
    private HandshakeConfiguration handshake;
    private String environment;
    private DomainService domainService;
    private DateService dateService;
    private RestDispatcher restMessageDispatcher;
    private AdministrationService administrationService;
    private KeepAliveService keepAliveService;
    private AuthorizationService authorizationService;
    private URI serverURI;
    private WSConnection wsConnection;
    private volatile WSSession wsSession;

    public synchronized void initialise(String consoleUri, ProxyAuthConfiguration proxyAuthConfiguration, boolean enabled, String environment, HandshakeConfiguration handshake, SecurityConfiguration security, AdministrationService administrationService, DomainService domainService, DateService dateService, Set<ExternalMessageHandler> externalMessageHandlers) throws AgentInitializationException {
        this.enabled = enabled;
        this.environment = environment;
        this.handshake = handshake;
        this.security = security;
        this.administrationService = administrationService;
        this.domainService = domainService;
        this.dateService = dateService;
        try {
            this.serverURI = new URI(consoleUri);
            this.wsConnection = new WSConnectionFactory(this).createWSConnection(proxyAuthConfiguration);
            this.restMessageDispatcher = new RestDispatcher();
            this.restMessageDispatcher.addRestListeners(externalMessageHandlers);
            this.restMessageDispatcher.init();
            this.parser = new HttpBodyParser(this.restMessageDispatcher.getMessageBodyFactory());
            this.serverId = this.administrationService.getMuleServerId();
            this.contextId = this.administrationService.getMuleContextId();
            this.agentVersion = this.administrationService.getAgentVersion();
            this.isTraceWSEnabled = Boolean.parseBoolean(System.getProperty(CONFIG_TRACE_WS_ENABLED));
        }
        catch (URISyntaxException e) {
            LOGGER.error("Could not initialise WebSocket Client: The URL is malformed", (Throwable)e);
            throw new AgentInitializationException("Could not initialise WebSocket Client: The URL is malformed", (Exception)e);
        }
        catch (NullPointerException e) {
            String message = String.format("Could not initialise WebSocket Client: %s", e.getCause());
            LOGGER.error(message, (Throwable)e);
            throw new AgentInitializationException(message, (Exception)e);
        }
        catch (DispatcherInitialisationException e) {
            LOGGER.error("Could not initialise WebSocket Client: The message dispatcher could not initialise", (Throwable)e);
            throw new AgentInitializationException("Could not initialise WebSocket Client: The message dispatcher could not initialise", (Exception)((Object)e));
        }
        catch (Exception e) {
            LOGGER.error("Could not initialise WebSocket Client: The socket could not be created", (Throwable)e);
            throw new AgentInitializationException("Could not initialise WebSocket Client: The socket could not be created", e);
        }
    }

    public synchronized void start() throws AgentStartException {
        try {
            this.restMessageDispatcher.start();
            if (this.isEnabled()) {
                LOGGER.debug("Before WS connection");
                this.connect(this.serverURI);
                LOGGER.debug("Starting KeepAlive service");
                this.keepAliveService = this.getKeepAliveService();
                this.keepAliveService.start();
            } else {
                LOGGER.debug("Not able to start because it's not not enabled");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not start WebSocket Client: Could not connect to %s server.", this.serverURI.getHost()), (Throwable)e);
            throw new AgentStartException(String.format("Could not start WebSocket Client: Could not connect to %s server", this.serverURI.getHost()), e);
        }
    }

    public void stop() throws AgentStopException {
        if (this.wsConnection != null) {
            this.wsConnection.close();
        }
        if (this.keepAliveService != null) {
            this.keepAliveService.stop();
        }
        this.unAuthorizeCommunication();
        try {
            this.closeSession();
        }
        catch (IOException e) {
            throw new AgentStopException("The socket could not be closed", (Exception)e);
        }
    }

    public void enableIncomingRequests() {
        LOGGER.debug("Enabling WS incoming requests.");
        this.muleStarted.set(true);
        try {
            if (this.authorizationService != null && this.authorizationService.isCommunicationAuthorized()) {
                LOGGER.debug("Authorized to send startup notification.");
                this.initialiseKeepAliveService();
            } else {
                LOGGER.debug("Not authorized to send startup notification. Auth service: {}", (Object)this.authorizationService);
            }
        }
        catch (IOException e) {
            LOGGER.error("Mule startup notification could not be sent, the external service is unreachable");
            LOGGER.debug((Object)e);
        }
        catch (InsecureTransportException e) {
            LOGGER.error("Mule startup notification could not be sent, the channel is insecure");
            LOGGER.debug((Object)e);
        }
    }

    public boolean send(Request message) throws IOException, InsecureTransportException {
        if (!this.isEnabled()) {
            return false;
        }
        BasicHttpRequest request = new BasicHttpRequest(message.getMethod(), message.getResource());
        if (message.getBody() != null) {
            BasicHttpEntityEnclosingRequest httpRequest = new BasicHttpEntityEnclosingRequest(message.getMethod(), message.getResource());
            InputStreamEntity entity = new InputStreamEntity(this.parser.toInputStream(message.getBody(), message.getType()));
            entity.setContentType(message.getType());
            httpRequest.setEntity((HttpEntity)entity);
            httpRequest.addHeader((Header)new BasicHeader("Content-Type", message.getType()));
            if (this.serverId != null) {
                httpRequest.addHeader((Header)new BasicHeader(X_ANYPNT_SERVER_ID, this.serverId));
            }
            if (this.contextId != null) {
                httpRequest.addHeader((Header)new BasicHeader(X_ANYPNT_CTX_ID, this.contextId));
            }
            if (this.agentVersion != null) {
                httpRequest.addHeader((Header)new BasicHeader(X_ANYPNT_AGENT_VERSION, this.agentVersion));
            }
            request = httpRequest;
        }
        AgentHttpRequest httpMessage = new AgentHttpRequest((HttpRequest)request);
        if (!this.sessionIsOpen()) {
            boolean retrySendResponse = this.retrySend((AgentMessage)httpMessage);
            if (retrySendResponse) {
                LOGGER.debug("Sending notification (after retry connection): " + message.getMethod() + " " + message.getResource() + " " + httpMessage.getProtocol());
            }
            return retrySendResponse;
        }
        boolean sendResponse = this.send((AgentMessage)httpMessage);
        if (sendResponse) {
            LOGGER.debug("Sending notification: " + message.getMethod() + " " + message.getResource());
        }
        return sendResponse;
    }

    public void onMessageReceived(byte[] payload) {
        int httpLength = 4;
        String protocol = new String(Arrays.copyOfRange(payload, 0, 4));
        if ("HTTP".equals(protocol)) {
            try {
                boolean authorized = this.authorizationService.authorize(new WSResponseParser(payload).parse());
                if (authorized && this.muleStarted.get()) {
                    this.enableIncomingRequests();
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
        } else {
            try {
                this.traceMessage("Receiving", payload);
                this.processRequest(new WSRequestParser(payload));
            }
            catch (ProtocolException e) {
                this.sendError(null, "Message could not be parsed");
            }
            catch (IOException e) {
                this.sendError(null, "Message could not be parsed");
            }
        }
    }

    public void onMessageReceived(String data) {
        if (this.isResponseMessage(data)) {
            try {
                boolean authorized = this.authorizationService.authorize(new WSResponseParser(data).parse());
                if (authorized && this.muleStarted.get()) {
                    this.enableIncomingRequests();
                }
            }
            catch (IOException e) {
                LOGGER.debug((Object)e);
            }
        } else {
            try {
                this.traceMessage("Receiving string", data != null ? data.getBytes() : new byte[]{});
                this.processRequest(new WSRequestParser(data));
            }
            catch (ProtocolException e) {
                this.sendError(null, "Message could not be parsed");
            }
            catch (IOException e) {
                this.sendError(null, "Message could not be parsed");
            }
        }
    }

    public boolean isConnected() {
        return this.wsSession != null && this.wsSession.isOpen() && this.authorizationService.isCommunicationAuthorized();
    }

    public void createAuthorizationService() {
        LOGGER.debug("Instantiating authorization service.");
        if (this.handshake != null && this.handshake.isEnabled()) {
            this.authorizationService = new HandshakeAuthorizationService(this.administrationService, this.dateService, this.wsSession, this.handshake);
            this.authorizationService.authorizeCommunication();
        } else {
            LOGGER.debug("No handshake service found, using NullAuthorizationService.");
            this.authorizationService = new NullAuthorizationService();
        }
    }

    public void unAuthorizeCommunication() {
        LOGGER.debug("Unauthorizing WebSocket communication");
        if (this.authorizationService != null) {
            this.authorizationService.unAuthorizeCommunication();
        }
    }

    public boolean sessionIsOpen() {
        return this.wsSession != null && this.wsSession.isOpen();
    }

    public TrustManagerFactory loadSSLContext(SSLContext sslContext) throws AgentInitializationException {
        if (this.security == null || this.security.getKeyStoreAlias() == null) {
            LOGGER.warn("Web socket is starting without security");
            return null;
        }
        try {
            char[] keystorePassword = this.administrationService.decrypt(this.security.getKeyStorePassword());
            SSLContextLoader sslContextLoader = new SSLContextLoader.Builder(this.shouldUsePublicTrustStore(), FipsUtils.getKeystoreType()).loadKeyStore(this.security.getKeyStoreFile(), keystorePassword, this.administrationService.decrypt(this.security.getKeyStoreAliasPassword())).loadTrustStore(this.security.getTrustStoreFile(), FipsUtils.getTrustStorePassword((char[])keystorePassword)).build();
            sslContextLoader.init(sslContext);
            return sslContextLoader.getTrustManagerFactory();
        }
        catch (KeyStoreException e) {
            LOGGER.error("Invalid KeyStore format. Your key store is not valid. Agent only support JKS KeyStore.", (Throwable)e);
            throw new AgentInitializationException("Invalid KeyStore format. Your key store is not valid. Agent only support JKS KeyStore.", (Exception)e);
        }
        catch (CertificateException e) {
            LOGGER.error("Invalid certificate algorithm. Your key store is not valid. Agent only support JKS KeyStore.", (Throwable)e);
            throw new AgentInitializationException("Invalid certificate algorithm. Your key store is not valid. Agent only support JKS KeyStore.", (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Invalid KeyStore algorithm. Your key store is not valid. Agent only support JKS KeyStore.", (Throwable)e);
            throw new AgentInitializationException("Invalid KeyStore algorithm. Your key store is not valid. Agent only support JKS KeyStore.", (Exception)e);
        }
        catch (FileNotFoundException | KeyManagementException | UnrecoverableKeyException e) {
            LOGGER.error("Unable to read KeyStore/TrustStore file for web socket ssl connection", (Throwable)e);
            throw new AgentInitializationException("Unable to read KeyStore/TrustStore file for web socket ssl connection", e);
        }
        catch (IOException e) {
            LOGGER.error("Unable to read KeyStore/TrustStore file for web socket ssl connection", (Throwable)e);
            throw new AgentInitializationException("Unable to read KeyStore/TrustStore file for web socket ssl connection", (Exception)e);
        }
        catch (AgentEncryptionException e) {
            LOGGER.error("Unable to decrypt the keystore password.", (Throwable)e);
            throw new AgentInitializationException("Unable to decrypt the keystore password.", (Exception)((Object)e));
        }
    }

    public WSSession getWsSession() {
        return this.wsSession;
    }

    public void setWSSession(WSSession wsSession) {
        this.wsSession = wsSession;
    }

    private void processRequest(WSRequestParser wsRequestParser) throws ProtocolException {
        AgentHttpRequest request = wsRequestParser.parse();
        if (this.sessionIsOpen()) {
            if (this.authorizationService.isCommunicationAuthorized()) {
                try {
                    LOGGER.debug("Received request " + request.getHeader(MESSAGE_ID_HEADER) + ": " + request.getMethod() + " " + request.getRequestURI() + " " + request.getProtocol());
                    AgentHttpResponse dispatch = this.restMessageDispatcher.dispatch((HttpServletRequest)request);
                    dispatch.addHeader(MESSAGE_ID_HEADER, request.getHeader(MESSAGE_ID_HEADER));
                    if (dispatch.getStatus() == 0) {
                        dispatch.setStatus(Response.Status.NOT_FOUND.getStatusCode());
                    }
                    if (this.send((AgentMessage)dispatch)) {
                        LOGGER.debug("Responding to request " + request.getHeader(MESSAGE_ID_HEADER) + " : " + request.getProtocol() + " " + dispatch.getStatus());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Sending error to request {} : {} {} {}", (Object)request.getHeader(MESSAGE_ID_HEADER), (Object)request.getMethod(), (Object)request.getRequestURI(), (Object)request.getProtocol(), (Object)e);
                    this.sendError(request.getHeader(MESSAGE_ID_HEADER), e.getMessage());
                }
            }
        } else {
            LOGGER.error("Connection was lost after the message was received");
        }
    }

    private void sendError(String messageId, String errorMessage) {
        try {
            AgentHttpResponse errorResponse = new AgentHttpResponse();
            errorResponse.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            errorResponse.setContentType("application/json");
            errorResponse.getWriter().print("{\"message\":\"" + errorMessage + "\"");
            errorResponse.addHeader(MESSAGE_ID_HEADER, messageId);
            if (this.send((AgentMessage)errorResponse)) {
                LOGGER.debug("Responding to request " + messageId + " : " + errorResponse.getProtocol() + " " + errorResponse.getStatus());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred and cannot be notified to console");
            LOGGER.debug((Object)e);
        }
    }

    private boolean isResponseMessage(String data) {
        return data.startsWith(HTTP_PROTOCOL_VERSION);
    }

    private boolean send(AgentMessage serialisedMessage) throws IOException, InsecureTransportException {
        if (!this.sessionIsOpen()) {
            return this.retrySend(serialisedMessage);
        }
        return this.doSend(serialisedMessage);
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    private void initialiseKeepAliveService() throws IOException, InsecureTransportException {
        LOGGER.debug("Creating Startup request.");
        Request request = new Request();
        request.setMethod("POST");
        request.setResource("startup");
        Map body = this.handshake != null && this.handshake.getBody() != null ? this.handshake.getBody() : new HashMap();
        Gson gson = new Gson();
        body.put("domains", gson.toJson((Object)this.domainService.listDomains()));
        body.put("addresses", gson.toJson((Object)this.administrationService.listAddresses()));
        request.setBody(body);
        this.send(request);
    }

    private boolean shouldUsePublicTrustStore() {
        return this.environment == null || !this.environment.equals(RuntimeEnvironment.ON_PREM.getValue());
    }

    private KeepAliveService getKeepAliveService() {
        return this.keepAliveService != null ? this.keepAliveService : new KeepAliveService(this);
    }

    private void closeSession() throws IOException {
        if (this.wsSession != null && this.wsSession.isOpen()) {
            this.wsSession.close();
        }
    }

    private boolean retrySend(AgentMessage message) throws IOException {
        if (!this.checkedConnect() || this.authorizationService == null) {
            return false;
        }
        this.authorizationService.authorizeCommunication();
        boolean retrySuccessful = false;
        for (int i = 0; i < 3 && !retrySuccessful; ++i) {
            try {
                try {
                    this.doSend(message);
                    retrySuccessful = true;
                }
                catch (InsecureTransportException e) {
                    Thread.sleep(800L);
                }
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Current thread was interrupted, while it was retrying the message delivery");
                LOGGER.debug((Object)e);
                Thread.currentThread().interrupt();
            }
        }
        if (retrySuccessful) {
            return true;
        }
        LOGGER.debug("The external service is unreachable, the message will be dismissed");
        return false;
    }

    private boolean doSend(AgentMessage message) throws IOException, InsecureTransportException {
        if (this.authorizationService != null && this.authorizationService.isCommunicationAuthorized()) {
            this.traceMessage("Sending", message.asByteArray());
            this.wsSession.sendBytes(message.asByteArray());
            return true;
        }
        throw new InsecureTransportException("The Web socket channel is not authorized yet");
    }

    private void traceMessage(String action, byte[] message) {
        if (!this.isTraceWSEnabled) {
            return;
        }
        String messageAsString = new String(message);
        if (messageAsString.contains(DISPLAYABLE_MSG_CONTENT)) {
            LOGGER.info("\r\n");
            LOGGER.info("*************************** {} message start", (Object)action);
            LOGGER.info(messageAsString);
            LOGGER.info("*************************** {} message end", (Object)action);
        }
    }

    private boolean checkedConnect() {
        try {
            this.connect(this.serverURI);
        }
        catch (Exception e) {
            LOGGER.debug("Error when trying to reconnect", (Throwable)e);
            return false;
        }
        return true;
    }

    private void connect(URI serverURI) {
        this.wsConnection.connect(serverURI, this.administrationService);
    }
}

