/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import com.google.common.base.Optional;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.common.ProxyConfiguration;
import com.mulesoft.agent.configuration.common.ProxyKerberosConfiguration;
import com.mulesoft.agent.configuration.common.SecurityConfiguration;
import com.mulesoft.agent.dispatch.HandshakeConfiguration;
import com.mulesoft.agent.exception.AgentException;
import com.mulesoft.agent.exception.AgentInitializationException;
import com.mulesoft.agent.exception.AgentStartException;
import com.mulesoft.agent.exception.AgentStopException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.DomainService;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import com.mulesoft.agent.transport.WebSocketCommunicationService;
import com.mulesoft.agent.util.ProxyConfigurationHelper;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.ext.MessageBodyReader;

@Named(value="websocket.transport")
@Singleton
public class WebSocketAgentTransport
implements AgentTransport<Request, Response> {
    @Inject
    private List<MessageBodyReader> readers;
    @Configurable(value="true")
    private boolean enabled = true;
    @Configurable
    private String environment;
    @Inject
    private Set<ExternalMessageHandler> externalMessageHandlers;
    @Inject
    private AdministrationService administrationService;
    @Inject
    private DomainService domainService;
    @Inject
    private DateService dateService;
    @Configurable
    private String consoleUri;
    @Configurable(value="{}")
    private SecurityConfiguration security;
    @Configurable
    private HandshakeConfiguration handshake;
    @Configurable(value="{}")
    private ProxyConfiguration proxyConfiguration;
    @Configurable(value="{}")
    private ProxyKerberosConfiguration proxyKerberosConfiguration;
    private WebSocketCommunicationService webSocketCommunicationService = new WebSocketCommunicationService();

    public synchronized void initialise() throws AgentInitializationException {
        ProxyAuthConfiguration proxyAuthConfiguration = ProxyConfigurationHelper.createProxyAuthConfiguration((ProxyConfiguration)this.proxyConfiguration, (ProxyKerberosConfiguration)this.proxyKerberosConfiguration);
        this.webSocketCommunicationService.initialise(this.consoleUri, proxyAuthConfiguration, this.enabled, this.environment, this.handshake, this.security, this.administrationService, this.domainService, this.dateService, this.externalMessageHandlers);
    }

    public synchronized void start() throws AgentStartException {
        this.webSocketCommunicationService.start();
    }

    public void stop() throws AgentStopException {
        this.webSocketCommunicationService.stop();
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableIncomingRequests() throws AgentException {
        this.webSocketCommunicationService.enableIncomingRequests();
    }

    public Optional<Response> send(Request message) throws IOException, InsecureTransportException {
        this.webSocketCommunicationService.send(message);
        return Optional.absent();
    }

    public boolean isConnected() {
        return this.webSocketCommunicationService.isConnected();
    }
}

