/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.transport;

import com.mulesoft.agent.transport.NettySslContextBuilder;
import com.mulesoft.agent.transport.WebSocketCommunicationService;
import com.mulesoft.agent.transport.connections.AsyncHttpWSConnection;
import com.mulesoft.agent.transport.connections.OkHttpWSConnection;
import com.mulesoft.agent.transport.connections.WSConnection;
import com.mulesoft.agent.transport.handlers.AsyncHttpWebSocketHandler;
import com.mulesoft.agent.transport.handlers.OkHttpWebSocketHandler;
import com.mulesoft.agent.transport.listeners.AsyncHttpWebSocketListener;
import com.mulesoft.agent.transport.listeners.OkHttpWebSocketListener;
import com.mulesoft.agent.util.client.okhttp.HTTPSUtils;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.proxy.ProxyServer;

public class WSConnectionFactory {
    private static final Logger LOGGER = LogManager.getLogger(WSConnectionFactory.class);
    private static final int WEBSOCKET_MAX_FRAME_SIZE = Integer.MAX_VALUE;
    public static final String TLS_VERSION = "TLSv1.2";
    private WebSocketCommunicationService webSocketCommunicationService;

    public WSConnectionFactory(WebSocketCommunicationService webSocketCommunicationService) {
        this.webSocketCommunicationService = webSocketCommunicationService;
    }

    public WSConnection createWSConnection(ProxyAuthConfiguration proxyAuthConfiguration) throws Exception {
        if (proxyAuthConfiguration.isValidKerberosAuthConfiguration()) {
            return this.createOkHttpWSConnection(proxyAuthConfiguration);
        }
        return this.createAsyncHttpWSConnection(proxyAuthConfiguration);
    }

    private OkHttpWSConnection createOkHttpWSConnection(ProxyAuthConfiguration proxyAuthConfiguration) throws Exception {
        LOGGER.debug("Configuring Client with Kerberos Proxy for host: {}, port: {}, user: {}, krb5ConfigurationPath: {}, jaasConfigurationPath: {}", (Object)proxyAuthConfiguration.getHost(), (Object)proxyAuthConfiguration.getPort(), (Object)proxyAuthConfiguration.getUser(), (Object)proxyAuthConfiguration.getKrb5ConfigurationPath(), (Object)proxyAuthConfiguration.getJaasConfigurationPath());
        SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
        TrustManagerFactory trustManagerFactory = this.webSocketCommunicationService.loadSSLContext(sslContext);
        OkHttpClient wsClient = HTTPSUtils.buildWsClient((ProxyAuthConfiguration)proxyAuthConfiguration);
        wsClient = HTTPSUtils.configureMutualTlsInHttpClient((OkHttpClient)wsClient, (SSLContext)sslContext, (TrustManagerFactory)trustManagerFactory);
        OkHttpWebSocketHandler webSocketHandler = new OkHttpWebSocketHandler(this.webSocketCommunicationService);
        return new OkHttpWSConnection(wsClient, (OkHttpWebSocketListener)webSocketHandler);
    }

    private AsyncHttpWSConnection createAsyncHttpWSConnection(ProxyAuthConfiguration proxyAuthConfiguration) throws Exception {
        SSLContext sslContext = SSLContext.getInstance(TLS_VERSION);
        this.webSocketCommunicationService.loadSSLContext(sslContext);
        ProxyServer proxyServer = null;
        if (proxyAuthConfiguration != null && proxyAuthConfiguration.getHost() != null && proxyAuthConfiguration.getPort() != null) {
            URI uri = URI.create(proxyAuthConfiguration.getHost());
            String host = uri.getHost();
            String scheme = uri.getScheme();
            if (scheme == null) {
                host = proxyAuthConfiguration.getHost();
            }
            proxyServer = proxyAuthConfiguration.getUser() != null && proxyAuthConfiguration.getPassword() != null ? new ProxyServer.Builder(host, proxyAuthConfiguration.getPort().intValue()).setRealm(Dsl.basicAuthRealm((String)proxyAuthConfiguration.getUser(), (String)proxyAuthConfiguration.getPassword()).build()).build() : new ProxyServer.Builder(host, proxyAuthConfiguration.getPort().intValue()).build();
        }
        DefaultEventExecutor webSocketInboundExecutor = new DefaultEventExecutor(runnable -> new Thread(runnable, "WebSocketInboundExecutor"));
        AsyncHttpClientConfig config = this.createWebSocketClient(sslContext, (EventExecutorGroup)webSocketInboundExecutor, Optional.ofNullable(proxyServer));
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient(config);
        AsyncHttpWebSocketHandler webSocketHandler = new AsyncHttpWebSocketHandler(this.webSocketCommunicationService);
        return new AsyncHttpWSConnection((AsyncHttpClient)client, (AsyncHttpWebSocketListener)webSocketHandler, proxyAuthConfiguration);
    }

    private AsyncHttpClientConfig createWebSocketClient(SSLContext sslContext, EventExecutorGroup webSocketInboundExecutor, Optional<ProxyServer> proxyServer) {
        DefaultAsyncHttpClientConfig.Builder asyncHttpClientBuilder = new DefaultAsyncHttpClientConfig.Builder().setThreadPoolName("WebSocketAgent_AsyncHttpClient").setSslContext(NettySslContextBuilder.newInstance((SSLContext)sslContext).build()).setWebSocketMaxFrameSize(Integer.MAX_VALUE).addChannelOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT).setWsAdditionalChannelInitializer(channel -> {
            ChannelPipeline pipeline = channel.pipeline();
            ChannelHandler channelHandler = pipeline.get("ahc-ws");
            pipeline.remove("ahc-ws");
            pipeline.addLast(webSocketInboundExecutor, "ahc-ws", channelHandler);
        });
        proxyServer.ifPresent(arg_0 -> ((DefaultAsyncHttpClientConfig.Builder)asyncHttpClientBuilder).setProxyServer(arg_0));
        return asyncHttpClientBuilder.build();
    }
}

