/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.security;

import com.google.gson.Gson;
import com.mulesoft.agent.dispatch.AgentHttpResponse;
import com.mulesoft.agent.dispatch.HandshakeConfiguration;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.DateService;
import com.mulesoft.agent.services.security.AuthorizationService;
import com.mulesoft.agent.transport.sessions.WSSession;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.util.StringUtil;

public class HandshakeAuthorizationService
implements AuthorizationService {
    private static final Logger LOGGER = LogManager.getLogger(HandshakeAuthorizationService.class);
    private static final String HANDSHAKE_PATH = "handshake";
    private static final String HANDSHAKE_REQUEST = "POST handshake HTTP/1.1\nContent-Type: application/json\nMessage-Id: %s\naccept: application/json\nContent-length:%s\n\n%s";
    private final DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private Status handShakeStatus = Status.UNAUTHORIZED;
    protected String messageId = null;
    private final AdministrationService administrationService;
    private final Gson parser = new Gson();
    private final DateService dateService;
    private final WSSession session;
    private HandshakeConfiguration handshakeConfiguration;

    public HandshakeAuthorizationService(AdministrationService administrationService, DateService dateService, WSSession session, HandshakeConfiguration handshakeConfiguration) {
        this.administrationService = administrationService;
        this.dateService = dateService;
        this.session = session;
        this.handshakeConfiguration = handshakeConfiguration;
    }

    @Override
    public synchronized void authorizeCommunication() {
        try {
            LOGGER.debug("Beginning authorize communication handshake service.");
            if (!this.handShakeStatus.equals((Object)Status.UNAUTHORIZED) || !this.session.isOpen()) {
                return;
            }
            this.handShakeStatus = Status.AUTHORIZING;
            this.handShakeStatus = Status.AUTHORIZING;
            this.messageId = UUID.randomUUID().toString();
            HashMap<String, String> hRq = new HashMap<String, String>();
            if (this.handshakeConfiguration != null && this.handshakeConfiguration.getBody() != null) {
                hRq.putAll(this.handshakeConfiguration.getBody());
            }
            hRq.put("agentVersion", this.administrationService.getAgentVersion());
            hRq.put("muleVersion", this.administrationService.getMuleVersion());
            hRq.put("gatewayVersion", this.administrationService.getGatewayVersion());
            hRq.put("serverType", this.administrationService.getServerType().toString());
            hRq.put("addresses", this.parser.toJson((Object)this.administrationService.listAddresses()));
            hRq.put("timeZone", TimeZone.getDefault().getID());
            HashMap<String, Object> runtimeInformation = new HashMap<String, Object>();
            runtimeInformation.put("osInformation", this.administrationService.getOSInformation());
            runtimeInformation.put("jvmInformation", this.administrationService.getJavaInformation());
            runtimeInformation.put("muleLicenseExpirationDate", this.administrationService.getMuleLicenseExpirationDate());
            hRq.put("runtimeInformation", this.parser.toJson(runtimeInformation));
            String content = this.parser.toJson(hRq);
            String message = String.format(HANDSHAKE_REQUEST, this.messageId, content.length(), content);
            this.session.sendBytes(message.getBytes());
        }
        catch (IOException e) {
            LOGGER.error("The message to be sent for authorization has an invalid format, the connection will remainun authorized");
            this.handShakeStatus = Status.UNAUTHORIZED;
        }
    }

    @Override
    public synchronized boolean authorize(AgentHttpResponse response) {
        if (this.handShakeStatus.equals((Object)Status.AUTHORIZING) && response != null && this.messageId != null && this.messageId.equals(response.getHeader("Message-Id"))) {
            if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                this.handShakeStatus = Status.AUTHORIZED;
                LOGGER.info("WebSocket Client connection authorized");
                String date = response.getHeader("Date");
                try {
                    if (StringUtil.isNotBlank((String)date)) {
                        Date parsedDate = this.dateFormat.parse(date);
                        this.dateService.sync(parsedDate);
                        LOGGER.debug("Retrieved date from server: '{}' - Calculated Local Date: '{}'.", (Object)parsedDate, (Object)this.dateService.getDate());
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("The date returned from the server has an error. Error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
                    LOGGER.debug((Object)t);
                }
                return true;
            }
            this.handShakeStatus = Status.UNAUTHORIZED;
            LOGGER.error("WebSocket Client connection refused by Console");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommunicationAuthorized() {
        Status status = this.handShakeStatus;
        synchronized (status) {
            return this.handShakeStatus.equals((Object)Status.AUTHORIZED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unAuthorizeCommunication() {
        Status status = this.handShakeStatus;
        synchronized (status) {
            this.handShakeStatus = Status.UNAUTHORIZED;
        }
    }

    static enum Status {
        AUTHORIZING,
        AUTHORIZED,
        UNAUTHORIZED;

    }
}

