/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services;

import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.WebSocketCommunicationService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeepAliveService
implements Runnable {
    public static final String AGENT_WEB_SOCKET_KEEP_ALIVE_FREQ = "agent.web.socket.keep.alive.freq";
    public static final String DEFAULT_SLEEP_TIME = "3000";
    public static final long RESTART_TIMEOUT = 10L;
    private static final Logger LOGGER = LogManager.getLogger(KeepAliveService.class);
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private long interval = Long.valueOf(System.getProperty("agent.web.socket.keep.alive.freq", "3000"));
    private final WebSocketCommunicationService client;
    private boolean isStarted = false;
    private long lastLogTime = 0L;
    private static final long LOG_INTERVAL_MS = 100000L;
    private long lastSuccessfulResponseTime = 0L;
    private int successfulResponses = 0;
    private int totalResponses = 0;

    public KeepAliveService(WebSocketCommunicationService client) {
        this.client = client;
    }

    public void stop() {
        this.service.shutdown();
        try {
            this.service.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Timeout elapsed waiting for the KeepAlive service to stop.", (Throwable)e);
        }
        this.isStarted = false;
    }

    public void start() {
        if (this.isStarted) {
            this.service.shutdown();
            try {
                this.service.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Error stopping the KeepAliveService: {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug("Error: ", (Throwable)e);
            }
            this.service = Executors.newSingleThreadScheduledExecutor();
        }
        this.service.scheduleWithFixedDelay(this, 0L, this.interval, TimeUnit.MILLISECONDS);
        this.isStarted = true;
    }

    @Override
    public void run() {
        try {
            Request message = new Request();
            message.setResource("keepAlive");
            message.setMethod("POST");
            boolean response = this.client.send(message);
            long currentTime = System.currentTimeMillis();
            if (response) {
                this.lastSuccessfulResponseTime = currentTime;
                ++this.successfulResponses;
            }
            ++this.totalResponses;
            if (currentTime - this.lastLogTime >= 100000L) {
                if (this.lastSuccessfulResponseTime > 0L) {
                    String formattedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.lastSuccessfulResponseTime));
                    LOGGER.info("successful keep-alive {} / {}  last at: {}", (Object)this.successfulResponses, (Object)this.totalResponses, (Object)formattedDate);
                } else {
                    LOGGER.info("No successful keep-alive responses yet");
                }
                this.successfulResponses = 0;
                this.totalResponses = 0;
                this.lastLogTime = currentTime;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Ping service could not be completed, the external service is unreachable: {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug("Error: ", (Throwable)e);
        }
        catch (InsecureTransportException e) {
            LOGGER.warn("Ping service could not be completed, the channel is insecure: {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug("Error: ", (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("Ping service could not be completed, unknown error: {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
            LOGGER.debug("Error: ", t);
        }
    }
}

