/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.valueprovider;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.AgentValueProviderService;
import com.mulesoft.agent.services.ToolingService;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.extension.api.persistence.value.ValueResultJsonSerializer;

@Named(value="com.mulesoft.agent.services.valueprovider")
@Path(value="/tooling")
@Singleton
public class ValueProviderRequestHandler
extends ConfigurableExternalHandler {
    private static final String PATH_SEPARATOR = "/";
    private static final String DOMAIN_NAME = "domains";
    private static final String APP_NAME = "applications";
    private static final String COMPONENT_NAME = "components";
    private static final String APP_PATH = "applications/{applications}";
    private static final String DOMAIN_PATH = "domains/{domains}";
    private static final String COMPONENT_PATH = "components/{components:(.*(\\/.*)*)}";
    private static final String PROVIDER_NAME = "providerName";
    private static final String VALUE_PROVIDER = "valueProviders/{providerName:(.+)}";
    private static final String APP_COMPONENT_ID = "applications/{applications}/components/{components:(.*(\\/.*)*)}/";
    private static final String DOMAIN_COMPONENT_ID = "domains/{domains}/components/{components:(.*(\\/.*)*)}/";
    private ResponseHelper responseHelper;
    @Inject
    private ToolingService toolingService;
    private boolean useCustomSerializer = false;
    @Inject
    private AgentValueProviderService valueProviderService;

    @PostConfigure
    public void start() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(ValueResultJsonSerializer.class.getName());
            this.useCustomSerializer = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        this.responseHelper = new ResponseHelper().addErrorMapping(NoSuchApplicationException.class, Response.Status.NOT_FOUND).addErrorMapping(NoSuchElementException.class, Response.Status.NOT_FOUND);
    }

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Path(value="applications/{applications}/components/{components:(.*(\\/.*)*)}/valueProviders/{providerName:(.+)}")
    @Produces(value={"application/json"})
    public Response applicationResolveValues(@PathParam(value="applications") String applicationId, @PathParam(value="components") String componentPath, @PathParam(value="providerName") String providerName) {
        return this.responseHelper.response(() -> this.newValueResultJsonSerializer().serialize(this.valueProviderService.getValues(this.toolingService.getDeployedApplication(applicationId), Location.builderFromStringRepresentation((String)componentPath).build(), providerName)));
    }

    @GET
    @Path(value="domains/{domains}/components/{components:(.*(\\/.*)*)}/valueProviders/{providerName:(.+)}")
    @Produces(value={"application/json"})
    public Response domainResolveValues(@PathParam(value="domains") String domainId, @PathParam(value="components") String componentPath, @PathParam(value="providerName") String providerName) {
        return this.responseHelper.response(() -> this.newValueResultJsonSerializer().serialize(this.valueProviderService.getValues(this.toolingService.getDeployedDomain(domainId), Location.builderFromStringRepresentation((String)componentPath).build(), providerName)));
    }

    private ValueResultJsonSerializerWrapper newValueResultJsonSerializer() {
        return this.useCustomSerializer ? valueResult -> new ValueResultJsonSerializer().serialize(valueResult) : valueResult -> new Gson().toJson((Object)valueResult);
    }

    private static interface ValueResultJsonSerializerWrapper {
        public String serialize(ValueResult var1);
    }
}

