/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.tooling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.domain.tooling.TestConnectionStatus;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.external.handlers.tooling.DeployToolingApplicationRequest;
import com.mulesoft.agent.external.handlers.tooling.DeployToolingDomainRequest;
import com.mulesoft.agent.external.handlers.tooling.ToolingApplicationResponse;
import com.mulesoft.agent.external.handlers.tooling.ToolingDomainResponse;
import com.mulesoft.agent.external.handlers.tooling.serialization.ErrorTypeTypeAdapter;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.ConnectivityTestingService;
import com.mulesoft.agent.services.MessageHistory;
import com.mulesoft.agent.services.ToolingService;
import com.mulesoft.agent.util.ResponseHelper;
import java.io.File;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.repository.api.BundleNotFoundException;

@Named(value="com.mulesoft.agent.services.tooling")
@Path(value="/tooling")
@Singleton
public class ToolingRequestHandler
extends ConfigurableExternalHandler {
    private static final String TOOLING_DOMAIN_LOCATION_OR_CONTENT_CANNOT_BE_NULL = "domainLocation or content cannot be empty";
    private static final String TOOLING_APPLICATION_LOCATION_OR_CONTENT_CANNOT_BE_NULL = "appLocation or content cannot be empty";
    private static final Logger LOGGER = LogManager.getLogger(ToolingRequestHandler.class);
    @Inject
    private ToolingService toolingService;
    @Inject
    private ConnectivityTestingService connectivityTestingService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private MessageHistory messageHistory;
    private ResponseHelper responseHelper;
    private Gson gson;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @PostConfigure
    public void start() {
        this.responseHelper = new ResponseHelper().addErrorMapping(NoSuchApplicationException.class, Response.Status.NOT_FOUND).addErrorMapping(BundleNotFoundException.class, Response.Status.NOT_FOUND).addErrorMapping(UnsupportedConnectivityTestingObjectException.class, Response.Status.METHOD_NOT_ALLOWED).addErrorMapping(ObjectNotFoundException.class, Response.Status.NOT_FOUND).addErrorMapping(IllegalArgumentException.class, Response.Status.BAD_REQUEST).addErrorMapping(UncheckedIOException.class, Response.Status.INTERNAL_SERVER_ERROR);
        this.gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ErrorType.class, (Object)new ErrorTypeTypeAdapter()).create();
    }

    @GET
    @Path(value="applications/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listToolingApplications(@QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> this.gson.toJson(this.toolingService.listToolingApplications().stream().map(appId -> new ToolingApplicationResponse((String)appId)).collect(Collectors.toList())), verbose);
    }

    @GET
    @Path(value="domains/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listToolingDomains(@QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> this.gson.toJson(this.toolingService.listToolingDomains().stream().map(domainId -> new ToolingDomainResponse((String)domainId)).collect(Collectors.toList())), verbose);
    }

    @PUT
    @Path(value="applications/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deployToolingApplication(DeployToolingApplicationRequest deployToolingApplicationRequest, @QueryParam(value="verbose") boolean verbose) {
        if (deployToolingApplicationRequest == null || StringUtils.isBlank((String)deployToolingApplicationRequest.getAppLocation()) && deployToolingApplicationRequest.getContent() == null) {
            return this.responseHelper.failure(Response.Status.BAD_REQUEST, TOOLING_APPLICATION_LOCATION_OR_CONTENT_CANNOT_BE_NULL, (Exception)new IllegalArgumentException(), verbose);
        }
        if (StringUtils.isNotBlank((String)deployToolingApplicationRequest.getAppLocation())) {
            if (StringUtils.isNotBlank((String)deployToolingApplicationRequest.getId())) {
                return this.responseHelper.response(() -> {
                    this.toolingService.deployToolingApplication(deployToolingApplicationRequest.getId(), new File(deployToolingApplicationRequest.getAppLocation()), deployToolingApplicationRequest.getDomainName(), Optional.ofNullable(deployToolingApplicationRequest.getDeploymentProperties()));
                    return this.gson.toJson((Object)new ToolingApplicationResponse(deployToolingApplicationRequest.getId()));
                }, verbose);
            }
            return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingApplicationResponse(this.toolingService.deployToolingApplication(new File(deployToolingApplicationRequest.getAppLocation()), deployToolingApplicationRequest.getDomainName(), Optional.ofNullable(deployToolingApplicationRequest.getDeploymentProperties())))), verbose);
        }
        if (StringUtils.isNotBlank((String)deployToolingApplicationRequest.getId())) {
            return this.responseHelper.response(() -> {
                this.toolingService.deployToolingApplication(deployToolingApplicationRequest.getId(), deployToolingApplicationRequest.getContent(), deployToolingApplicationRequest.getDomainName(), Optional.ofNullable(deployToolingApplicationRequest.getDeploymentProperties()));
                return this.gson.toJson((Object)new ToolingApplicationResponse(deployToolingApplicationRequest.getId()));
            }, verbose);
        }
        return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingApplicationResponse(this.toolingService.deployToolingApplication(deployToolingApplicationRequest.getContent(), deployToolingApplicationRequest.getDomainName(), Optional.ofNullable(deployToolingApplicationRequest.getDeploymentProperties())))), verbose);
    }

    @PUT
    @Path(value="domains/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deployToolingDomain(DeployToolingDomainRequest deployToolingDomainRequest, @QueryParam(value="verbose") boolean verbose) {
        if (deployToolingDomainRequest == null || StringUtils.isBlank((String)deployToolingDomainRequest.getDomainLocation()) && deployToolingDomainRequest.getContent() == null) {
            return this.responseHelper.failure(Response.Status.BAD_REQUEST, TOOLING_APPLICATION_LOCATION_OR_CONTENT_CANNOT_BE_NULL, (Exception)new IllegalArgumentException(), verbose);
        }
        if (StringUtils.isNotBlank((String)deployToolingDomainRequest.getDomainLocation())) {
            if (StringUtils.isNotBlank((String)deployToolingDomainRequest.getId())) {
                return this.responseHelper.response(() -> {
                    this.toolingService.deployToolingDomain(deployToolingDomainRequest.getId(), new File(deployToolingDomainRequest.getDomainLocation()), Optional.ofNullable(deployToolingDomainRequest.getDeploymentProperties()));
                    return this.gson.toJson((Object)new ToolingDomainResponse(deployToolingDomainRequest.getId()));
                }, verbose);
            }
            return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingDomainResponse(this.toolingService.deployToolingDomain(new File(deployToolingDomainRequest.getDomainLocation()), Optional.ofNullable(deployToolingDomainRequest.getDeploymentProperties())))), verbose);
        }
        if (StringUtils.isNotBlank((String)deployToolingDomainRequest.getId())) {
            return this.responseHelper.response(() -> {
                this.toolingService.deployToolingDomain(deployToolingDomainRequest.getId(), deployToolingDomainRequest.getContent(), Optional.ofNullable(deployToolingDomainRequest.getDeploymentProperties()));
                return this.gson.toJson((Object)new ToolingDomainResponse(deployToolingDomainRequest.getId()));
            }, verbose);
        }
        return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingDomainResponse(this.toolingService.deployToolingDomain(deployToolingDomainRequest.getContent(), Optional.ofNullable(deployToolingDomainRequest.getDeploymentProperties())))), verbose);
    }

    @PUT
    @Path(value="applications/{applicationName}/messagehistory")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response enableMessageHistory(@PathParam(value="applicationName") String applicationName, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> {
            if (this.applicationService.getApplication(applicationName) == null) {
                throw new NoSuchApplicationException("An application has to be already deployed in order to enable try it");
            }
            try {
                this.messageHistory.enableMessageHistory(applicationName);
            }
            catch (Exception e) {
                LOGGER.error("There was an unexpected error while enabling application for try it", (Throwable)e);
                throw e;
            }
            return "{ \"application\":{\"name\":\"" + applicationName + "\"}, \"status\":\"Try it enabled\" }";
        }, verbose);
    }

    @GET
    @Path(value="applications/{applicationName}/messagehistory")
    @Produces(value={"application/json"})
    public Response retrieveMessageHistoryNotifications(@PathParam(value="applicationName") String applicationName, @DefaultValue(value="10") @QueryParam(value="chunkSize") int chunkSize, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> this.messageHistory.retrieveNotifications(applicationName, chunkSize), verbose);
    }

    @DELETE
    @Path(value="applications/{applicationName}/messagehistory")
    @Produces(value={"application/json"})
    public Response disableMessageHistory(@PathParam(value="applicationName") String applicationName, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> {
            this.messageHistory.disableMessageHistory(applicationName);
            return "{ \"application\":{\"name\":\"" + applicationName + "\"}, \"status\":\"Try it disabled\" }";
        }, verbose);
    }

    @PUT
    @Path(value="applications/")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response deployToolingApplication(InputStream uploadedInputStream, @QueryParam(value="artifactId") String artifactId, @QueryParam(value="domainName") String domainName, @QueryParam(value="verbose") boolean verbose) {
        if (StringUtils.isNotBlank((String)artifactId)) {
            return this.responseHelper.response(() -> {
                this.toolingService.deployToolingApplication(artifactId, IOUtils.toByteArray((InputStream)uploadedInputStream), domainName, Optional.empty());
                return this.gson.toJson((Object)new ToolingApplicationResponse(artifactId));
            }, verbose);
        }
        return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingApplicationResponse(this.toolingService.deployToolingApplication(IOUtils.toByteArray((InputStream)uploadedInputStream), domainName, Optional.empty()))), verbose);
    }

    @PUT
    @Path(value="domains/")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response deployToolingDomain(InputStream uploadedInputStream, @QueryParam(value="artifactId") String artifactId, @QueryParam(value="verbose") boolean verbose) {
        if (StringUtils.isNotBlank((String)artifactId)) {
            return this.responseHelper.response(() -> {
                this.toolingService.deployToolingDomain(artifactId, IOUtils.toByteArray((InputStream)uploadedInputStream), Optional.empty());
                return this.gson.toJson((Object)new ToolingDomainResponse(artifactId));
            }, verbose);
        }
        return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingDomainResponse(this.toolingService.deployToolingDomain(IOUtils.toByteArray((InputStream)uploadedInputStream), Optional.empty()))), verbose);
    }

    @GET
    @Path(value="applications/{applicationId}/components/{componentId}/connection/")
    @Produces(value={"application/json"})
    public Response applicationTestConnection(@PathParam(value="applicationId") String applicationId, @PathParam(value="componentId") String componentId, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> {
            ConnectionValidationResult connectionValidationResult = this.connectivityTestingService.testConnection(this.toolingService.getDeployedApplication(applicationId), componentId);
            return this.gson.toJson((Object)TestConnectionStatus.testConnectionResult((ConnectionValidationResult)connectionValidationResult, (boolean)verbose));
        }, verbose);
    }

    @GET
    @Path(value="domains/{domainId}/components/{componentId}/connection/")
    @Produces(value={"application/json"})
    public Response domainTestConnection(@PathParam(value="domainId") String domainId, @PathParam(value="componentId") String componentId, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> {
            ConnectionValidationResult connectionValidationResult = this.connectivityTestingService.testConnection(this.toolingService.getDeployedDomain(domainId), componentId);
            return this.gson.toJson((Object)TestConnectionStatus.testConnectionResult((ConnectionValidationResult)connectionValidationResult, (boolean)verbose));
        }, verbose);
    }

    @DELETE
    @Path(value="applications/{applicationId}")
    @Produces(value={"application/json"})
    public Response disposeToolingApplication(@PathParam(value="applicationId") String applicationId, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingApplicationResponse(this.toolingService.disposeToolingApplication(applicationId))), verbose);
    }

    @DELETE
    @Path(value="domains/{domainId}")
    @Produces(value={"application/json"})
    public Response disposeToolingDomain(@PathParam(value="domainId") String domainId, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> this.gson.toJson((Object)new ToolingDomainResponse(this.toolingService.disposeToolingDomain(domainId))), verbose);
    }
}

