/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.installer;

import com.google.inject.Inject;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.AgentInstallerException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.InstallerService;
import java.io.InputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Named(value="installer.request.handler")
@Path(value="agent")
@Singleton
public class InstallerRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    private InstallerService installerService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response upgradeAgent(InputStream file) {
        if (this.isEnabled()) {
            try {
                this.installerService.upgradeAgent(file);
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\": \"" + e.getClass() + "\", \"errorMessage\": \"" + e.getMessage() + "\"}")).build();
            }
            catch (AgentInstallerException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\": \"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\": \"" + e.getMessage() + "\"}")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }
}

