/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.extensions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.ExtensionService;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.mule.runtime.api.meta.model.ExtensionModel;

@Named(value="extension.request.handler")
@Path(value="extensions")
@Singleton
public class ExtensionRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    private ExtensionService extensionService;
    private ResponseHelper responseHelper;

    @PostConfigure
    public void start() {
        this.responseHelper = new ResponseHelper().addEntityTransformer(response -> {
            if (response instanceof List) {
                return this.extensionService.toJson((List)response);
            }
            if (response instanceof Collection) {
                return this.extensionService.toJson((List)ImmutableList.copyOf((Collection)((Collection)response)));
            }
            if (response instanceof ExtensionModel) {
                return this.extensionService.toJson((ExtensionModel)response);
            }
            return response;
        }).addErrorMapping(NoSuchApplicationException.class, Response.Status.NOT_FOUND).addErrorMapping(NoSuchElementException.class, Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="{app_name}")
    @Produces(value={"application/json"})
    public Response getExtensions(@PathParam(value="app_name") String appName) {
        return this.responseHelper.response(() -> this.extensionService.getExtensionModels(appName));
    }

    @GET
    @Path(value="{app_name}/{extensionName}/{vendor}")
    @Produces(value={"application/json"})
    public Response getExtension(@PathParam(value="app_name") String appName, @PathParam(value="extensionName") String extensionName) {
        return this.responseHelper.response(() -> (ExtensionModel)this.extensionService.getExtensionModel(appName, extensionName).orElseThrow(() -> new NoSuchElementException(String.format("Could not find extension '%s' on application '%s'", extensionName, appName))));
    }

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }
}

