/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.dataweave;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.domain.tooling.dataweave.model.DataWeaveExecutionException;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.DataWeaveService;
import com.mulesoft.agent.services.ToolingService;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Named(value="dataweave.preview.handler")
@Path(value="/tooling")
@Singleton
public class DataWeaveRequestHandler
extends ConfigurableExternalHandler {
    private static final String MESSAGE_HANDLER_IS_DISABLED = "Message handler is disabled";
    @Inject
    protected ToolingService toolingService;
    @Inject
    protected DataWeaveService dataWeaveService;
    private ResponseHelper responseHelper;
    private Gson gson = new Gson();

    @PostConfigure
    public void start() {
        this.responseHelper = new ResponseHelper().addErrorMapping(NoSuchElementException.class, Response.Status.NOT_FOUND).addErrorMapping(IllegalArgumentException.class, Response.Status.NOT_FOUND).addErrorMapping(DataWeaveExecutionException.class, Response.Status.INTERNAL_SERVER_ERROR);
    }

    @POST
    @Path(value="applications/{applicationId}/dataweave/execute")
    @Produces(value={"application/json"})
    public Response executeOnApplication(@PathParam(value="applicationId") String applicationId, @QueryParam(value="verbose") boolean verbose, PreviewRequest parameters) {
        if (this.isEnabled()) {
            return this.responseHelper.response(() -> {
                PreviewResponse result = this.dataWeaveService.execute(this.toolingService.getDeployedApplication(applicationId), parameters);
                return this.gson.toJson((Object)result);
            }, verbose);
        }
        return this.responseHelper.failure(Response.Status.FORBIDDEN, MESSAGE_HANDLER_IS_DISABLED, (Exception)new IllegalAccessException(), verbose);
    }

    @POST
    @Path(value="domains/{domainId}/dataweave/execute")
    @Produces(value={"application/json"})
    public Response executeOnDomain(@PathParam(value="domainId") String domainId, @QueryParam(value="verbose") boolean verbose, PreviewRequest parameters) {
        if (this.isEnabled()) {
            return this.responseHelper.response(() -> {
                PreviewResponse result = this.dataWeaveService.execute(this.toolingService.getDeployedDomain(domainId), parameters);
                return this.gson.toJson((Object)result);
            }, verbose);
        }
        return this.responseHelper.failure(Response.Status.FORBIDDEN, MESSAGE_HANDLER_IS_DISABLED, (Exception)new IllegalAccessException(), verbose);
    }

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }
}

