/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.administration;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.domain.administration.AgentInfo;
import com.mulesoft.agent.domain.switcher.Component;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.exception.InvalidConfigurationException;
import com.mulesoft.agent.exception.InvalidFieldException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.external.handlers.PATCH;
import com.mulesoft.agent.services.AdministrationService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="components.configure.request.handler")
@Path(value="agent")
@Singleton
public class ComponentRequestHandler
extends ConfigurableExternalHandler {
    private static final Logger LOGGER = LogManager.getLogger(ComponentRequestHandler.class);
    @Inject
    protected AdministrationService administrationService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAgentInfo() {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setMuleStarted(this.administrationService.isMuleStarted());
        agentInfo.setMuleVersion(this.administrationService.getMuleVersion());
        agentInfo.setAgentVersion(this.administrationService.getAgentVersion());
        agentInfo.setServerId(this.administrationService.getMuleServerId());
        agentInfo.setContextId(this.administrationService.getMuleContextId());
        return Response.ok().entity((Object)agentInfo).build();
    }

    @GET
    @Path(value="components")
    @Produces(value={"application/json"})
    public Response getComponents() {
        if (this.isEnabled()) {
            LinkedList components = new LinkedList();
            components.addAll(this.administrationService.getExternalHandlerStatus());
            components.addAll(this.administrationService.getInternalHandlerStatus());
            components.addAll(this.administrationService.getServiceStatus());
            return Response.ok().entity(components).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public Response getConfiguration() {
        if (this.isEnabled()) {
            return Response.ok().entity((Object)this.administrationService.getConfiguration()).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @GET
    @Path(value="{component}")
    @Produces(value={"application/json"})
    public Response getComponentConfiguration(@PathParam(value="component") String component) {
        if (this.isEnabled()) {
            try {
                return Response.ok().entity((Object)this.administrationService.getConfiguration(component)).build();
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PATCH
    @Path(value="{component}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeComponentConfiguration(@PathParam(value="component") String component, Map<String, Object> rootNode) {
        if (this.isEnabled()) {
            try {
                Map<String, Object> parsedConfigurations = this.parseComponentConfiguration(component, rootNode);
                this.administrationService.changeConfiguration(component, parsedConfigurations);
            }
            catch (NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (AgentEnableOperationException e) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (InvalidConfigurationException | InvalidFieldException | IllegalArgumentException | NoSuchFieldException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (ComponentOperationException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        } else {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
    }

    @PUT
    @Path(value="{component}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response replaceComponentConfiguration(@PathParam(value="component") String component, Map rootNode) {
        if (this.isEnabled()) {
            try {
                Map<String, Object> parsedConfigurations = this.parseComponentConfiguration(component, rootNode);
                this.administrationService.replaceConfiguration(component, parsedConfigurations);
            }
            catch (ComponentOperationException | NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (JsonSyntaxException | InvalidConfigurationException | InvalidFieldException | NoSuchFieldException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (AgentEnableOperationException e) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        } else {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
    }

    @PUT
    @Path(value="{component}/enable")
    @Produces(value={"application/json"})
    public Response enableComponent(@PathParam(value="component") String component) {
        try {
            if (!this.isEnabled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
            }
            this.administrationService.switchComponent(component, true);
        }
        catch (AgentEnableOperationException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new Component(component, true)).build();
    }

    @PUT
    @Path(value="{component}/disable")
    @Produces(value={"application/json"})
    public Response disableComponent(@PathParam(value="component") String component) {
        try {
            if (!this.isEnabled()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
            }
            this.administrationService.switchComponent(component, false);
        }
        catch (AgentEnableOperationException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new Component(component, false)).build();
    }

    @PATCH
    @Path(value="{component}/{application}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeApplicationConfiguration(@PathParam(value="component") String component, @PathParam(value="application") String application, Map<String, Object> rootNode) {
        if (this.isEnabled()) {
            try {
                Map<String, ApplicationConfiguration[]> parsedConfigurations = this.parseApplicationConfiguration(component, rootNode);
                this.validateApplicationNameInConfiguration(component, application, parsedConfigurations);
                if (!parsedConfigurations.isEmpty()) {
                    this.administrationService.changeConfiguration(component, parsedConfigurations, application);
                }
            }
            catch (ComponentOperationException | NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (JsonSyntaxException | InvalidConfigurationException | InvalidFieldException | NoSuchFieldException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (AgentEnableOperationException e) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PUT
    @Path(value="{component}/{application}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response replaceApplicationComponentConfiguration(@PathParam(value="component") String component, @PathParam(value="application") String applicationName, Map rootNode) {
        if (this.isEnabled()) {
            try {
                Map<String, ApplicationConfiguration[]> parsedConfigurations = this.parseApplicationConfiguration(component, rootNode);
                this.validateApplicationNameInConfiguration(component, applicationName, parsedConfigurations);
                if (!parsedConfigurations.isEmpty()) {
                    this.administrationService.replaceConfiguration(component, parsedConfigurations, applicationName);
                }
            }
            catch (ComponentOperationException | NoSuchElementException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (InvalidConfigurationException | InvalidFieldException | NoSuchFieldException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (AgentEnableOperationException e) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PATCH
    @Path(value="{component}/scheduler")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response changeApplicationScheduler(@PathParam(value="component") String component, Map<String, Object> rootNode) {
        if (!this.isEnabled()) return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
        try {
            Map<String, ApplicationConfiguration[]> parsedConfigurations = this.parseApplicationConfiguration(component, rootNode);
            if (parsedConfigurations.isEmpty()) return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
            this.administrationService.updateConfiguration(component, parsedConfigurations);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (InvalidConfigurationException | InvalidFieldException | NoSuchFieldException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (AgentEnableOperationException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (ComponentOperationException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{component}/scheduler")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteApplicationScheduler(@PathParam(value="component") String component, Map<String, Object> rootNode) {
        if (!this.isEnabled()) return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
        try {
            Map<String, Object> parsedConfigurations = this.parseComponentConfiguration(component, rootNode);
            if (parsedConfigurations.isEmpty()) return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
            this.administrationService.deleteConfiguration(component, parsedConfigurations);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.administrationService.getConfiguration(component)).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (InvalidConfigurationException | InvalidFieldException | NoSuchFieldException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (AgentEnableOperationException | ComponentOperationException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
    }

    private Map<String, Object> parseComponentConfiguration(String componentId, Map<String, Object> fromConfiguration) throws NoSuchElementException, InvalidConfigurationException {
        HashMap<String, Object> parsedConfigurations = new HashMap<String, Object>();
        for (String fieldName : fromConfiguration.keySet()) {
            try {
                Object parsedConfiguration = this.administrationService.parseComponentConfiguration(componentId, fieldName, fromConfiguration.get(fieldName));
                parsedConfigurations.put(fieldName, parsedConfiguration);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("Ignored reference in configuration: {}", (Object)e.getMessage());
            }
            catch (JsonSyntaxException e) {
                String message = String.format("Could not parse value for reference '%s' in component '%s': %s", fieldName, componentId, e.getMessage());
                LOGGER.error(message);
                throw new InvalidConfigurationException(message);
            }
        }
        return parsedConfigurations;
    }

    private Map<String, ApplicationConfiguration[]> parseApplicationConfiguration(String componentId, Map<String, Object> fromConfiguration) throws InvalidConfigurationException, NoSuchElementException {
        HashMap<String, ApplicationConfiguration[]> parsedConfigurations = new HashMap<String, ApplicationConfiguration[]>();
        for (String fieldName : fromConfiguration.keySet()) {
            try {
                ApplicationConfiguration[] parsedConfiguration = this.administrationService.parseApplicationConfiguration(componentId, fieldName, fromConfiguration.get(fieldName));
                parsedConfigurations.put(fieldName, parsedConfiguration);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warn("Ignored reference in configuration: {}", (Object)e.getMessage());
            }
            catch (JsonSyntaxException e) {
                String message = String.format("Could not parse value for reference '%s' in component '%s': %s", fieldName, componentId, e.getMessage());
                LOGGER.error(message);
                throw new InvalidConfigurationException(message);
            }
        }
        return parsedConfigurations;
    }

    private void validateApplicationNameInConfiguration(String componentId, String applicationName, Map<String, ApplicationConfiguration[]> configuration) {
        for (String fieldName : configuration.keySet()) {
            Optional<ApplicationConfiguration> result = Arrays.stream((Object[])configuration.get(fieldName)).filter(e -> !applicationName.equals(e.getApplicationName())).findAny();
            if (!result.isPresent()) continue;
            String message = String.format("Application name from component configuration (%s) does not match artifact name (%s)", componentId, applicationName);
            throw new IllegalArgumentException(message);
        }
    }
}

