/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration.packager;

import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.m2.PomDefaults;
import org.mule.tooling.core.m2.plugin.MavenBuildPlugin;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.mule.tooling.update.migration.MigrationStep;
import org.mule.tooling.update.migration.ProjectMigrationStrategy;
import org.mule.tooling.update.migration.text.Messages;
import org.osgi.framework.Version;

public class UpdatePackagerVersionMigrationStrategy
implements ProjectMigrationStrategy {
    private static final String LATEST_MULE_MAVEN_PLUGIN_VERSION = PomDefaults.Pom_defaults_muleMavenPluginVersion;

    @Override
    public boolean applies(Version from, Version to) {
        return true;
    }

    @Override
    public boolean appliesTo(IProject project) {
        try {
            if (CoreUtils.hasMuleNature((IProject)project)) {
                Optional<MavenMuleProjectDecorator> optionalMavenProject = UpdatePackagerVersionMigrationStrategy.getMavenMuleProjectDecorator(project);
                return UpdatePackagerVersionMigrationStrategy.appliesForTheGivenPackagerVersion(optionalMavenProject, LATEST_MULE_MAVEN_PLUGIN_VERSION);
            }
        }
        catch (CoreException e) {
            MuleUpdatePlugin.logError("Error trying to check packager version for project " + project.getName(), e);
        }
        return false;
    }

    private static boolean appliesForTheGivenPackagerVersion(Optional<MavenMuleProjectDecorator> optionalMavenProject, String packagerVersion) {
        Optional muleMavenPlugin = optionalMavenProject.flatMap(mavenProject -> mavenProject.getPlugin("org.mule.tools.maven", "mule-maven-plugin"));
        if (muleMavenPlugin.isPresent()) {
            com.github.zafarkhaja.semver.Version requiredMuleMavenPlugin = MavenUtils.getVersion((String)packagerVersion);
            Optional<com.github.zafarkhaja.semver.Version> currentVersion = Optional.ofNullable(MavenUtils.getVersion((String)((MavenBuildPlugin)muleMavenPlugin.get()).getVersion()));
            return currentVersion.map(version2 -> version2.lessThan(requiredMuleMavenPlugin)).orElse(true);
        }
        return false;
    }

    @Override
    public MigrationStep createMigrationFor(IProject project, Version from, Version to) {
        return new UpdatePackagerVersionStep(project);
    }

    private static Optional<MavenMuleProjectDecorator> getMavenMuleProjectDecorator(IProject project) {
        return Optional.ofNullable(MuleRuntime.create((IProject)project)).map(MavenMuleProjectDecorator::decorate);
    }

    private static final class UpdatePackagerVersionStep
    implements MigrationStep {
        private final IProject project;

        private UpdatePackagerVersionStep(IProject project) {
            this.project = project;
        }

        @Override
        public String getShortDescription() {
            return Messages.PACKAGER_SHORT_DESCRIPTION;
        }

        @Override
        public String getLongDescription() {
            return Messages.PACKAGER_LONG_DESCRIPTION;
        }

        @Override
        public IStatus apply(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.PACKAGER_PROGRESS_TASK_NAME, this.project.getName()), (int)100);
            try {
                if (this.project.isAccessible()) {
                    MavenMuleProjectDecorator mavenProject = UpdatePackagerVersionMigrationStrategy.getMavenMuleProjectDecorator(this.project).orElseThrow(() -> new IllegalStateException("should be able to get a maven project decorator for project " + this.project.getName()));
                    subMonitor.split(50);
                    mavenProject.updatePluginVersion("org.mule.tools.maven", "mule-maven-plugin", PomDefaults.Pom_defaults_muleMavenPluginVersion);
                    subMonitor.split(50);
                }
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                MuleUpdatePlugin.logError(MessageFormat.format(Messages.PACKAGER_ERROR_LOG_MESSAGE, this.project.getName()), e);
                return new Status(8, "org.mule.tooling.update", MessageFormat.format(Messages.PACKAGER_RESULT_ERROR_MESSAGE, this.project.getName()));
            }
        }

        @Override
        public String getDocumentationLink() {
            return "https://docs.mulesoft.com/anypoint-studio/update-workspace";
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

