/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration.packager;

import java.io.File;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.mule.tooling.update.migration.MigrationStep;
import org.mule.tooling.update.migration.ProjectMigrationStrategy;
import org.mule.tooling.update.migration.text.Messages;
import org.osgi.framework.Version;

public class UpdateMuleArtifactMigrationStrategy
implements ProjectMigrationStrategy {
    private static final String JAVA_SPECIFICATION_VERSIONS = "javaSpecificationVersions";

    @Override
    public boolean applies(Version from, Version to) {
        return true;
    }

    @Override
    public boolean appliesTo(IProject project) {
        try {
            if (CoreUtils.hasMuleNature((IProject)project)) {
                return this.appliesForTheGivenMuleArtifact(project);
            }
        }
        catch (CoreException e) {
            MuleUpdatePlugin.logError("Error trying to check the if the fields in the mule-artifact.json file are present " + project.getName(), e);
        }
        return false;
    }

    @Override
    public MigrationStep createMigrationFor(IProject project, Version from, Version to) {
        return new UpdateMuleArtifactStep(project);
    }

    private boolean appliesForTheGivenMuleArtifact(IProject project) {
        IPath location = project.getFile("mule-artifact.json").getLocation();
        if (location != null) {
            Optional javaSpecificationVersions = CoreUtils.getValueInMuleArtifact((File)location.toFile(), (String)JAVA_SPECIFICATION_VERSIONS);
            return javaSpecificationVersions.isEmpty();
        }
        return false;
    }

    private static Optional<String> getJavaVersion(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                return Optional.ofNullable(ProjectClasspathUtils.getShortJavaVersion((IJavaProject)javaProject));
            }
        }
        catch (CoreException e) {
            MuleUpdatePlugin.logError("Error trying to check the Java version " + project.getName(), e);
        }
        return Optional.empty();
    }

    private static final class UpdateMuleArtifactStep
    implements MigrationStep {
        private final IProject project;

        private UpdateMuleArtifactStep(IProject project) {
            this.project = project;
        }

        @Override
        public String getShortDescription() {
            return Messages.MULE_ARTIFACT_SHORT_DESCRIPTION;
        }

        @Override
        public String getLongDescription() {
            return Messages.MULE_ARTIFACT_LONG_DESCRIPTION;
        }

        @Override
        public IStatus apply(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.MULE_ARTIFACT_PROGRESS_TASK_NAME, this.project.getName()), (int)100);
            try {
                if (this.project.isAccessible()) {
                    String javaVersion = UpdateMuleArtifactMigrationStrategy.getJavaVersion(this.project).orElseThrow(() -> new IllegalStateException("Should be able to get the Java version for project " + this.project.getName()));
                    subMonitor.split(50);
                    String[] version = new String[]{javaVersion};
                    IPath location = this.project.getFile("mule-artifact.json").getLocation();
                    CoreUtils.updateFieldInMuleArtifactJson((File)location.toFile(), (String)UpdateMuleArtifactMigrationStrategy.JAVA_SPECIFICATION_VERSIONS, (Object)version);
                    subMonitor.split(50);
                }
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                MuleUpdatePlugin.logError(MessageFormat.format(Messages.MULE_ARTIFACT_ERROR_LOG_MESSAGE, this.project.getName()), e);
                return new Status(8, "org.mule.tooling.update", MessageFormat.format(Messages.MULE_ARTIFACT_RESULT_ERROR_MESSAGE, this.project.getName()));
            }
        }

        @Override
        public String getDocumentationLink() {
            return "https://docs.mulesoft.com/anypoint-studio/update-workspace";
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

