/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration.packager;

import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.ExchangeMavenFacade;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.mule.tooling.update.migration.MigrationStep;
import org.mule.tooling.update.migration.ProjectMigrationStrategy;
import org.mule.tooling.update.migration.text.Messages;
import org.osgi.framework.Version;

public class UpdateExchangeRepositoryMigrationStrategy
implements ProjectMigrationStrategy {
    @Override
    public boolean applies(Version from, Version to) {
        return true;
    }

    @Override
    public boolean appliesTo(IProject project) {
        try {
            if (CoreUtils.hasMuleNature((IProject)project) && this.isAddExchangeRepositoriesToPomEnabled()) {
                Optional<MavenMuleProjectDecorator> optionalMavenProject = UpdateExchangeRepositoryMigrationStrategy.getMavenMuleProjectDecorator(project);
                return UpdateExchangeRepositoryMigrationStrategy.appliesForTheGivenExchangeRepository(optionalMavenProject);
            }
        }
        catch (CoreException e) {
            MuleUpdatePlugin.logError("Error trying to check the if the Anypoint Exchange v3 repository is present in project " + project.getName(), e);
        }
        return false;
    }

    @Override
    public MigrationStep createMigrationFor(IProject project, Version from, Version to) {
        return new AddAnypointExchangeRepositoryStep(project);
    }

    private static boolean appliesForTheGivenExchangeRepository(Optional<MavenMuleProjectDecorator> optionalMavenProject) {
        if (optionalMavenProject.isPresent()) {
            for (Repository repository : optionalMavenProject.get().getRepositories()) {
                if (!repository.getId().equals(ExchangeMavenFacade.getCurrentId())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAddExchangeRepositoriesToPomEnabled() {
        return MuleUIPlugin.getDefault().getPreferenceStore().getBoolean("add_exchange_repositories_to pom");
    }

    private static Optional<MavenMuleProjectDecorator> getMavenMuleProjectDecorator(IProject project) {
        return Optional.ofNullable(MuleRuntime.create((IProject)project)).map(MavenMuleProjectDecorator::decorate);
    }

    private static final class AddAnypointExchangeRepositoryStep
    implements MigrationStep {
        private final IProject project;

        private AddAnypointExchangeRepositoryStep(IProject project) {
            this.project = project;
        }

        @Override
        public String getShortDescription() {
            return Messages.EXCHANGE_REPOSITORY_SHORT_DESCRIPTION;
        }

        @Override
        public String getLongDescription() {
            return Messages.EXCHANGE_REPOSITORY_LONG_DESCRIPTION;
        }

        @Override
        public IStatus apply(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.EXCHANGE_REPOSITORY_PROGRESS_TASK_NAME, this.project.getName()), (int)100);
            try {
                if (this.project.isAccessible()) {
                    MavenMuleProjectDecorator mavenProject = UpdateExchangeRepositoryMigrationStrategy.getMavenMuleProjectDecorator(this.project).orElseThrow(() -> new IllegalStateException("should be able to get a maven project decorator for project " + this.project.getName()));
                    subMonitor.split(50);
                    mavenProject.addRepository(ExchangeMavenFacade.getCurrentId(), ExchangeMavenFacade.getCurrentName(), PlatformUrls.getMavenFacadeUrl());
                    subMonitor.split(50);
                }
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                MuleUpdatePlugin.logError(MessageFormat.format(Messages.EXCHANGE_REPOSITORY_ERROR_LOG_MESSAGE, this.project.getName()), e);
                return new Status(8, "org.mule.tooling.update", MessageFormat.format(Messages.EXCHANGE_REPOSITORY_RESULT_ERROR_MESSAGE, this.project.getName()));
            }
        }

        @Override
        public String getDocumentationLink() {
            return "https://docs.mulesoft.com/anypoint-studio/update-workspace";
        }

        @Override
        public IProject getProject() {
            return this.project;
        }
    }
}

