/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.update.migration.MigrationDialog;
import org.mule.tooling.update.migration.MigrationStep;
import org.mule.tooling.update.migration.ProjectMigrationStrategy;
import org.osgi.framework.Version;

public class MigrationStrategyManager {
    static final String APPLYING_COMPATIBILITY_MESSAGE = "Applying compatibility upgrade tasks";
    private static final MigrationStrategyManager INSTANCE = new MigrationStrategyManager();
    protected List<ProjectMigrationStrategy> projectMigrationStrategies;

    public static MigrationStrategyManager getInstance() {
        return INSTANCE;
    }

    public void checkAndApplyMigrationFor(List<IProject> projects) {
        final ArrayList<MigrationStep> migrationSteps = new ArrayList<MigrationStep>();
        for (IProject project : projects) {
            migrationSteps.addAll(this.resolveMigrationStepsFor(project, Version.emptyVersion, Version.emptyVersion));
        }
        if (migrationSteps.isEmpty()) {
            return;
        }
        UIJob migrationJob = new UIJob(this.getDisplay(), APPLYING_COMPATIBILITY_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MigrationDialog dialog = new MigrationDialog(activeShell, migrationSteps);
                int confirmation = dialog.open();
                if (confirmation == 0) {
                    Map<MigrationStep, Boolean> migrations = dialog.getMigrationsSelected();
                    LinkedList<MigrationStep> migrationsToPerform = new LinkedList<MigrationStep>();
                    for (MigrationStep step : migrationSteps) {
                        boolean update = migrations.getOrDefault(step, false);
                        if (!update) continue;
                        migrationsToPerform.add(step);
                    }
                    return MigrationStrategyManager.runMigrationStepsInDialog(migrationsToPerform, activeShell);
                }
                return Status.OK_STATUS;
            }
        };
        migrationJob.setPriority(10);
        migrationJob.schedule();
    }

    public boolean anyProjectAppliesForMigration(List<IProject> projects) {
        boolean existProjectForMigration = false;
        for (ProjectMigrationStrategy migrationStrategy : this.getProjectMigrationStrategies()) {
            if (!projects.stream().anyMatch(project -> migrationStrategy.appliesTo(project))) continue;
            existProjectForMigration = true;
        }
        return existProjectForMigration;
    }

    public static IStatus runMigrationStepsInDialog(final List<MigrationStep> migrationSteps, Shell activeShell) {
        final MultiStatus multiStatus = new MultiStatus("org.mule.tooling.update", 0, APPLYING_COMPATIBILITY_MESSAGE, null);
        try {
            ProgressMonitorDialog migrationProgressMonitorDialog = new ProgressMonitorDialog(activeShell);
            migrationProgressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(MigrationStrategyManager.APPLYING_COMPATIBILITY_MESSAGE, migrationSteps.size());
                        for (MigrationStep migrationStep : migrationSteps) {
                            multiStatus.add(migrationStep.apply((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            multiStatus.add((IStatus)new Status(8, "org.mule.tooling.update", ExceptionUtils.getMessage((Throwable)e), (Throwable)e));
        }
        catch (InterruptedException e) {
            multiStatus.add((IStatus)new Status(8, "org.mule.tooling.update", ExceptionUtils.getMessage((Throwable)e), (Throwable)e));
        }
        if (multiStatus.isOK()) {
            MessageDialog.openInformation((Shell)activeShell, (String)"Project update process", (String)"Update process was completed successfully");
        } else {
            StringBuilder message = new StringBuilder("Update process was finished with the following problems:\n");
            IStatus[] iStatusArray = multiStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                if (!status.isOK()) {
                    message.append(" - ");
                    message.append(status.getMessage());
                    message.append("\n");
                }
                ++n2;
            }
            MessageDialog.openWarning((Shell)activeShell, (String)"Project update process", (String)message.toString());
        }
        return multiStatus;
    }

    private Display getDisplay() {
        Display current = Display.getCurrent();
        current = current == null ? Display.getDefault() : current;
        return current;
    }

    public List<MigrationStep> resolveMigrationStepsFor(IProject project, Version fromVersion, Version toVersion) {
        ArrayList<MigrationStep> migrationSteps = new ArrayList<MigrationStep>();
        for (ProjectMigrationStrategy projectMigrationStrategy : this.getProjectMigrationStrategies()) {
            if (!projectMigrationStrategy.appliesTo(project)) continue;
            MigrationStep migrationStep = projectMigrationStrategy.createMigrationFor(project, fromVersion, toVersion);
            migrationSteps.add(migrationStep);
        }
        return migrationSteps;
    }

    protected List<ProjectMigrationStrategy> getProjectMigrationStrategies() {
        if (this.projectMigrationStrategies == null) {
            this.projectMigrationStrategies = CoreUtils.getExtensionPointObjects((String)"org.mule.tooling.update.migration", ProjectMigrationStrategy.class);
        }
        return this.projectMigrationStrategies;
    }

    public List<MigrationStep> resolveMigrationStepsFor(Version fromVersion, Version toVersion) {
        IProject[] projects;
        ArrayList<MigrationStep> allSteps = new ArrayList<MigrationStep>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            allSteps.addAll(this.resolveMigrationStepsFor(project, fromVersion, toVersion));
            ++n2;
        }
        return allSteps;
    }
}

