/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.update.migration.MigrationStrategyManager;

public class MigrationStrategyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<IProject> projectsForMigration = new ArrayList<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        boolean anyProjectApplyForMigration = MigrationStrategyManager.getInstance().anyProjectAppliesForMigration(projectsForMigration);
        if (anyProjectApplyForMigration) {
            MigrationStrategyManager.getInstance().checkAndApplyMigrationFor(projectsForMigration);
        } else {
            final Display display = Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)"Anypoint Studio", (String)"All the open projects are already up to date");
                }
            });
        }
        return null;
    }
}

