/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.util.FormLayoutUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.mule.tooling.update.migration.MigrationStep;

public class MigrationStepsComposite
extends Composite {
    private static final String DESELECT_ALL = "Deselect all";
    private static final String SELECT_ALL = "Select all";
    private static final String ACCESS_MIGRATION_AGAIN_LABEL = "This dialog can be opened again by opening the Help menu and selecting \"Validate workspace compatibility\"";
    private static final String MULE_PROJECTS = "Mule Projects";
    private static final String ERROR_OPENING_LINK_DOCUMENTATION = "Error opening documentation link for migration";
    private static final String LINK_LABEL = "<a>Learn more</a>";
    private static final String FOR_PROJECTS = " for the projects:";
    public static final String TITLE = "Update your Workspace";
    public static final String DESCRIPTION = "The current workspace has configuration files that need to be updated to work with the latest version of Anypoint Studio.";
    private static final String LABEL_TEXT_WITH_API_PROJECTS = "Please select the changes you want to perform once the \"Perform Update\" button is pressed.";
    private List<MigrationStep> migrationSteps;
    private Map<MigrationStep, Boolean> stepsSelected = new HashMap<MigrationStep, Boolean>();
    private Consumer<Boolean> checkboxChangedConsumer;

    public MigrationStepsComposite(Composite parent, List<MigrationStep> steps, Consumer<Boolean> onCheckboxChanged) {
        super(parent, 0);
        this.migrationSteps = steps;
        this.checkboxChangedConsumer = onCheckboxChanged;
        this.createControl(this);
        this.forceFocus();
    }

    private void createControl(Composite parent) {
        this.setFont(parent.getFont());
        Label label = new Label((Composite)this, 64);
        label.setText(LABEL_TEXT_WITH_API_PROJECTS);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Label lastCreatedComponent = label;
        this.createGroupWithSteps(parent, (Control)lastCreatedComponent, this.migrationSteps);
        Text informationText = new Text((Composite)this, 74);
        informationText.setBackground(this.getBackground());
        informationText.setText(ACCESS_MIGRATION_AGAIN_LABEL);
        GridDataFactory.fillDefaults().indent(5, 0).align(4, 0x1000000).applyTo((Control)informationText);
    }

    private Control createGroupWithSteps(Composite parent, Control lastCreatedComponent, List<MigrationStep> migrationSteps) {
        Group muleProjectGroup = UiUtils.createGroupWithTitle((Composite)parent, (String)MULE_PROJECTS, (int)1);
        WidgetUtils.setFontStyle((Control)muleProjectGroup, (int)1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)muleProjectGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)muleProjectGroup);
        HashMap typesOfMigration = new HashMap();
        for (MigrationStep migrationStep : migrationSteps) {
            if (!typesOfMigration.containsKey(migrationStep.getClass())) {
                typesOfMigration.put(migrationStep.getClass(), new LinkedList());
            }
            ((List)typesOfMigration.get(migrationStep.getClass())).add(migrationStep);
        }
        for (Map.Entry entry : typesOfMigration.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            lastCreatedComponent = this.addGroupForMigrations((Composite)muleProjectGroup, lastCreatedComponent, (MigrationStep)((List)entry.getValue()).get(0), (List)entry.getValue());
        }
        return lastCreatedComponent;
    }

    private Control addGroupForMigrations(Composite parent, Control lastCreatedComponent, final MigrationStep mainStep, List<MigrationStep> steps) {
        Composite stepComposite = new Composite(parent, 0);
        stepComposite.setLayout((Layout)FormLayoutUtils.formLayout((int)0, (int)0));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)stepComposite);
        Label label = new Label(stepComposite, 524288);
        label.setText(mainStep.getShortDescription() + FOR_PROJECTS);
        FormLayoutUtils.attach((Control)label).top().left();
        CLabel infoApiVersionImag = new CLabel(stepComposite, 0);
        infoApiVersionImag.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        infoApiVersionImag.setToolTipText(mainStep.getLongDescription());
        FormLayoutUtils.attach((Control)infoApiVersionImag).topFrom(lastCreatedComponent, 0).leftFrom((Control)label, 0);
        if (!StringUtils.isBlank((String)mainStep.getDocumentationLink())) {
            Link link = new Link(stepComposite, 524288);
            link.setText(LINK_LABEL);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        Program.launch((String)mainStep.getDocumentationLink());
                    }
                    catch (Exception e) {
                        MuleUpdatePlugin.logError(MigrationStepsComposite.ERROR_OPENING_LINK_DOCUMENTATION, e);
                    }
                }
            });
            FormLayoutUtils.attach((Control)link).top(0).leftFrom((Control)infoApiVersionImag, 5);
        }
        lastCreatedComponent = label;
        this.createTableWithProjects(lastCreatedComponent, steps, stepComposite);
        return stepComposite;
    }

    private void createTableWithProjects(Control lastCreatedComponent, List<MigrationStep> steps, Composite stepComposite) {
        Composite gridComposite = new Composite(stepComposite, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 5, 0).numColumns(2).equalWidth(false).applyTo(gridComposite);
        FormLayoutUtils.attach((Control)gridComposite).topFrom(lastCreatedComponent, 5).left().right();
        final TableViewer checkboxTable = new TableViewer(gridComposite, 2596);
        int height = 80;
        for (MigrationStep step : steps) {
            TableItem item = new TableItem(checkboxTable.getTable(), 0);
            item.setText(step.getProject().getName());
            item.setChecked(true);
            item.setData((Object)step);
            height = item.getBounds().height * 4;
            this.stepsSelected.put(step, true);
        }
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, height).align(4, 1).applyTo((Control)checkboxTable.getTable());
        Composite buttonsComposite = new Composite(gridComposite, 0);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(buttonsComposite);
        final Button selectAllButton = new Button(buttonsComposite, 8);
        selectAllButton.setText(SELECT_ALL);
        Dialog.applyDialogFont((Control)selectAllButton);
        final Button deselectAllButton = new Button(buttonsComposite, 8);
        deselectAllButton.setText(DESELECT_ALL);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Arrays.asList(checkboxTable.getTable().getItems()).forEach(item -> {
                    item.setChecked(true);
                    MigrationStepsComposite.this.handleButtonCheckedChange((TableItem)item, selectAllButton, deselectAllButton);
                });
            }
        });
        Dialog.applyDialogFont((Control)deselectAllButton);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Arrays.asList(checkboxTable.getTable().getItems()).forEach(item -> {
                    item.setChecked(false);
                    MigrationStepsComposite.this.handleButtonCheckedChange((TableItem)item, selectAllButton, deselectAllButton);
                });
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)selectAllButton);
        GridDataFactory.fillDefaults().align(4, 1).indent(0, 0).applyTo((Control)deselectAllButton);
        checkboxTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MigrationStepsComposite.this.handleButtonCheckedChange((TableItem)e.item, selectAllButton, deselectAllButton);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        selectAllButton.setEnabled(false);
    }

    private void handleButtonCheckedChange(TableItem item, Button selectAllButton, Button deselectAllButton) {
        this.stepsSelected.put((MigrationStep)item.getData(), item.getChecked());
        this.checkboxChangedConsumer.accept(this.hasCheckboxSelected());
        deselectAllButton.setEnabled(!this.areAllDeselected());
        selectAllButton.setEnabled(!this.areAllSelected());
    }

    private boolean hasCheckboxSelected() {
        for (Map.Entry<MigrationStep, Boolean> entry : this.stepsSelected.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean areAllSelected() {
        for (Map.Entry<MigrationStep, Boolean> entry : this.stepsSelected.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllDeselected() {
        for (Map.Entry<MigrationStep, Boolean> entry : this.stepsSelected.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Map<MigrationStep, Boolean> getMigrationsStepsStatus() {
        return this.stepsSelected;
    }

    public List<MigrationStep> getMigrationSteps() {
        return this.migrationSteps;
    }
}

