/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update.migration;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.update.migration.MigrationStep;
import org.mule.tooling.update.migration.MigrationStepsComposite;

public class MigrationDialog
extends TitleAreaDialog {
    private static final String SHELL_TITLE = "Anypoint Studio";
    private static final String CANCEL_MESSAGE = "We strongly recommend going through the workspace upgrade process.\n\nAre you sure you want to cancel?";
    private static final String LABEL_MIGRATION_OK = "Perform update";
    private List<MigrationStep> migrationSteps;
    private MigrationStepsComposite migrationStepsComposite;

    public MigrationDialog(Shell parentShell, List<MigrationStep> migrationSteps) {
        super(parentShell);
        this.migrationSteps = migrationSteps;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            return super.createButton(parent, id, LABEL_MIGRATION_OK, defaultButton);
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            boolean reallyCancel = MessageDialog.openQuestion((Shell)this.getShell(), (String)SHELL_TITLE, (String)CANCEL_MESSAGE);
            if (reallyCancel) {
                super.buttonPressed(buttonId);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(SHELL_TITLE);
        this.setTitle("Update your Workspace");
        this.setMessage("The current workspace has configuration files that need to be updated to work with the latest version of Anypoint Studio.");
    }

    public Map<MigrationStep, Boolean> getMigrationsSelected() {
        return this.migrationStepsComposite.getMigrationsStepsStatus();
    }

    protected void handleShellCloseEvent() {
        this.buttonPressed(1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        this.migrationStepsComposite = new MigrationStepsComposite(dialogAreaComposite, this.migrationSteps, enabled -> this.getButton(0).setEnabled(enabled.booleanValue()));
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 5).applyTo((Control)this.migrationStepsComposite);
        GridLayoutFactory.createFrom((GridLayout)((GridLayout)parent.getLayout())).margins(5, 5).applyTo(dialogAreaComposite);
        return this.migrationStepsComposite;
    }
}

