/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IStartup;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.update.CheckUpdateJob;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.mule.tooling.update.migration.MigrationStrategyManager;

public class UpdatePluginStartup
implements IStartup {
    public void earlyStartup() {
        if (!"true".equals(System.getProperty("studio.test", ""))) {
            CheckUpdateJob checkUpdateJob = new CheckUpdateJob(MuleUpdatePlugin.getDefault().getBundle(), MuleUpdatePlugin.getDefault().getPreferenceStore());
            checkUpdateJob.addJobChangeListener((IJobChangeListener)new RegisterProjectMigrationCheckListener());
            checkUpdateJob.schedule();
        }
    }

    private static final class ProjectMigrationCheckListener
    implements IResourceChangeListener {
        protected static final long MIGRATION_TIMER_DELAY = 1000L;
        private List<IProject> projectsForMigration = new ArrayList<IProject>();
        private Timer timer = new Timer("Migration for opening projects timer");

        public ProjectMigrationCheckListener() {
            this.projectsForMigration = new ArrayList<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event == null || event.getDelta() == null) {
                return;
            }
            try {
                if ((event.getType() & 2) == 0) {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IProject project;
                            IResource resource = delta.getResource();
                            int flags = delta.getFlags();
                            if ((flags & 0x4000) != 0 && resource instanceof IProject && (project = (IProject)resource).isAccessible()) {
                                projectsForMigration.add(project);
                                if (projectsForMigration.size() == 1) {
                                    this.scheduleMigrationTask();
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"Error installing migration handlers...", (Throwable)e);
            }
        }

        private void scheduleMigrationTask() {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    List<IProject> projectsForMigrationReference = projectsForMigration;
                    projectsForMigration = new ArrayList<IProject>();
                    MigrationStrategyManager.getInstance().checkAndApplyMigrationFor(projectsForMigrationReference);
                }
            }, 1000L);
        }
    }

    static final class RegisterProjectMigrationCheckListener
    extends JobChangeAdapter {
        RegisterProjectMigrationCheckListener() {
        }

        public void done(IJobChangeEvent jobChangeEvent) {
            ProjectMigrationCheckListener listener = new ProjectMigrationCheckListener();
            listener.scheduleMigrationTask();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        }
    }
}

