/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.mule.tooling.core.MuleCorePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SaveInstallInformationJob
extends Job {
    private static final String FIELD_SEPARATOR = ",";
    private static final String BUNDLE_SEPARATOR = ";";
    private static final String EMPTY_INFO = "";
    public static final String JOB_NAME = "Saving installation information";
    private static final String PREVIOUS_INFO_PREF_ID = "org.mule.tooling.update.previousInstallInformation";
    private static final String CURRENT_INFO_PREF_ID = "org.mule.tooling.update.currentInstallInformation";
    private final Bundle bundle;
    private final IEclipsePreferences preferences;

    public SaveInstallInformationJob(Bundle bundle, IEclipsePreferences preferences) {
        super(JOB_NAME);
        this.bundle = bundle;
        this.preferences = preferences;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            BundleContext bundleContext = this.bundle.getBundleContext();
            if (bundleContext != null) {
                Bundle[] bundles = bundleContext.getBundles();
                String previousInstallInformation = this.preferences.get(CURRENT_INFO_PREF_ID, EMPTY_INFO);
                this.preferences.put(PREVIOUS_INFO_PREF_ID, previousInstallInformation);
                String currentInstallInformation = SaveInstallInformationJob.getInstallInformationString(bundles);
                this.preferences.put(CURRENT_INFO_PREF_ID, currentInstallInformation);
                this.preferences.flush();
                this.log("previous", previousInstallInformation);
                this.log("current", currentInstallInformation);
            }
        }
        catch (Throwable e) {
            MuleCorePlugin.logError((String)"There was a problem saving install information", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private void log(String infoLabel, String previousInstallInformation) {
        MuleCorePlugin.logInfo((String)("Saved " + infoLabel + " install information: " + this.displayInfo(previousInstallInformation)));
    }

    private String displayInfo(String info) {
        return EMPTY_INFO.equals(info) ? "<no information>" : "\n" + info;
    }

    public static String getInstallInformationString(Bundle[] bundles) {
        StringBuilder infoBuilder = new StringBuilder(EMPTY_INFO);
        if (bundles != null) {
            int i = 0;
            while (i < bundles.length) {
                Bundle bundle = bundles[i];
                String symbolicName = bundle.getSymbolicName();
                String location = bundle.getLocation();
                String version = bundle.getVersion().toString();
                long lastModified = bundle.getLastModified();
                if (i > 0) {
                    infoBuilder.append(BUNDLE_SEPARATOR);
                }
                infoBuilder.append(symbolicName);
                infoBuilder.append(FIELD_SEPARATOR);
                infoBuilder.append(version);
                infoBuilder.append(FIELD_SEPARATOR);
                infoBuilder.append(lastModified);
                infoBuilder.append(FIELD_SEPARATOR);
                infoBuilder.append(location);
                ++i;
            }
        }
        return infoBuilder.toString();
    }
}

