/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.browser.BrowserProxy;
import org.mule.tooling.browser.IBrowser;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.update.ReleaseNote;
import org.mule.tooling.update.welcome.AnalyticsProvider;
import org.osgi.framework.Bundle;

public class NewWelcomePage
extends Window {
    private static final int MIN_DIALOG_WIDTH = 620;
    private static final int MIN_DIALOG_HEIGHT = 740;
    private static final int MAX_DIALOG_WIDTH = 850;
    private static final int MAX_DIALOG_HEIGHT = 1172;
    private static final int FIXED_MIN_DIALOG_WIDTH = 620;
    private static final int FIXED_MIN_DIALOG_HEIGHT = 730;
    private Boolean acceptAnalytics = this.getAnalyticsDefaultValue();
    private Double maxScrolled = 0.0;
    private Properties properties = new Properties();
    private WelcomeSize calcBound = (studioValue, objValue) -> (studioValue - objValue) / 2;
    private IBrowser browser;

    public NewWelcomePage() {
        super(Display.getDefault().getActiveShell());
        this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF & 0xFFFFFF7F | 0x10000);
    }

    protected Control createContents(Composite parent) {
        this.browser = BrowserProxy.createBrowser((Composite)parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.browser.getComposite());
        Bundle bundle = Platform.getBundle((String)"org.mule.tooling.update");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("welcome/welcome.html"), null);
        URL urlReleaseNote = FileLocator.find((Bundle)bundle, (IPath)new Path("welcome/release_note_template.html"), null);
        URL urlProperties = FileLocator.find((Bundle)bundle, (IPath)new Path("welcome/welcome.properties"), null);
        try {
            url = FileLocator.resolve((URL)url);
            urlReleaseNote = FileLocator.resolve((URL)urlReleaseNote);
            urlProperties = FileLocator.resolve((URL)urlProperties);
            this.properties.load(new FileInputStream(new File(urlProperties.getFile())));
            File file = new File(url.getPath());
            String htmlString = FileUtils.readFileToString((File)new File(url.getFile()));
            htmlString = String.format(htmlString, file.getPath(), ThemeUtils.getCurrentTheme().getWelcomePageCss(), ThemeUtils.getCurrentTheme().getWelcomePageLogoImg(), this.properties.getProperty("RELEASE_NOTES_VERSION"), this.properties.getProperty("RELEASE_NOTES_TYPE"), this.getReleaseNotesHtml(new File(urlReleaseNote.getFile())));
            java.nio.file.Path tempFile = Files.createTempFile("", ".html", new FileAttribute[0]);
            Throwable throwable = null;
            Object var10_12 = null;
            try (FileOutputStream os = new FileOutputStream(tempFile.toFile());){
                IOUtils.write((String)htmlString, (OutputStream)os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.browser.setUrl(tempFile.toUri().toURL().toString());
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)"Could not find welcome page source files", (Throwable)e);
        }
        this.browser.getComposite().layout();
        this.calculateWelcomePageSize();
        this.addWelcomeListeners(this.browser);
        this.addWelcomeFunctions(this.browser);
        return parent;
    }

    private String getReleaseNotesHtml(File releaseNoteTemplate) throws IOException {
        ArrayList<ReleaseNote> releaseNotes = new ArrayList<ReleaseNote>();
        int i = 1;
        while (this.getProperty("RELEASE_NOTE_%s_TITLE", i) != null) {
            ReleaseNote releaseNote = new ReleaseNote(this.getProperty("RELEASE_NOTE_%s_TITLE", i), this.getProperty("RELEASE_NOTE_%s_TEXT", i), this.getProperty("RELEASE_NOTE_%s_BADGE", i), this.getProperty("RELEASE_NOTE_%s_IMG_TEXT", i), this.getProperty("RELEASE_NOTE_%s_IMG_NAME", i), this.getProperty("RELEASE_NOTE_%s_IMG_WIDTH", i), this.getProperty("RELEASE_NOTE_%s_IMG_HEIGHT", i));
            releaseNotes.add(releaseNote);
            ++i;
        }
        String template = FileUtils.readFileToString((File)releaseNoteTemplate);
        return releaseNotes.stream().map(rn -> rn.fillReleaseNoteTemplate(template)).reduce("", String::concat);
    }

    private String getProperty(String propertyName, int i) {
        return this.properties.getProperty(String.format(propertyName, i));
    }

    protected void calculateWelcomePageSize() {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        int studioWidth = parentShell.getBounds().width;
        int studioHeight = parentShell.getBounds().height;
        int welcomeWidth = studioWidth / 2;
        int welcomeHeight = studioHeight - 15;
        int welcomex = this.calcBound.calc(studioWidth, welcomeWidth);
        int welcomey = this.calcBound.calc(studioHeight, welcomeHeight);
        if (studioWidth / 2 < 620 || studioHeight < 740) {
            welcomex = this.calcBound.calc(studioWidth, 620);
            welcomey = this.calcBound.calc(studioHeight, 740);
            welcomeWidth = 620;
            welcomeHeight = 740;
        }
        if (studioWidth / 2 > 850 || studioHeight > 1172) {
            welcomex = this.calcBound.calc(studioWidth, 850);
            welcomey = this.calcBound.calc(studioHeight, 1172);
            welcomeWidth = 850;
            welcomeHeight = 1172;
        }
        this.getShell().setMinimumSize(620, 730);
        this.getShell().setBounds(parentShell.getBounds().x + welcomex, parentShell.getBounds().y + welcomey, welcomeWidth, welcomeHeight);
    }

    protected void addWelcomeFunctions(IBrowser browser) {
        browser.addFunction("acceptAnalytics", o -> {
            AnalyticsProvider.setUpdated(true);
            this.acceptAnalytics = Boolean.TRUE;
            return null;
        });
        browser.addFunction("rejectAnalytics", arguments -> {
            AnalyticsProvider.setUpdated(true);
            this.acceptAnalytics = Boolean.FALSE;
            return null;
        });
        browser.addFunction("closeWindowPage", arguments -> {
            AnalyticsRecordsFactory.single((String)Events.WELCOME_PAGE_CONTINUE).track();
            this.getShell().getDisplay().asyncExec(() -> {
                this.maxScrolled = (Double)browser.evaluate("return maxScrolled;");
                this.close();
            });
            return null;
        });
        browser.addFunction("getDefaultAnalytics", arguments -> String.valueOf(this.getAnalyticsDefaultValue()));
        browser.addFunction("openStartGuide", arguments -> {
            this.launchStartGuide();
            return null;
        });
        browser.addFunction("openReleaseNotes", arguments -> {
            this.launchReleaseNotes();
            return null;
        });
        browser.addFunction("openGettingStarted", arguments -> {
            this.launchGettingStarted();
            return null;
        });
        browser.addFunction("openTutorials", arguments -> {
            this.launchTutorials();
            return null;
        });
    }

    protected void addWelcomeListeners(final IBrowser browser) {
        browser.getComposite().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (27 == e.keyCode || e.character == '\u001b') {
                    NewWelcomePage.this.maxScrolled = (Double)browser.evaluate("return maxScrolled;");
                    NewWelcomePage.this.close();
                }
            }
        });
    }

    public boolean getAnalyticsDefaultValue() {
        if (AnalyticsProvider.isUpdated()) {
            return AnalyticsProvider.isAnalyticsAccepted();
        }
        return true;
    }

    protected void updateAnalytics() {
        if (this.acceptAnalytics != AnalyticsProvider.isAnalyticsAccepted()) {
            AnalyticsProvider.acceptAnalyticsPreference(this.acceptAnalytics);
        }
    }

    private void launchStartGuide() {
        AnalyticsRecordsFactory.single((String)Events.START_QUICK_GUIDE, (String[])new String[]{"guideNumber", "2", "from", "Studio Splash Screen"}).track();
        this.launch("https://developer.mulesoft.com/tutorials-and-howtos/quick-start/developing-your-first-mule-application/", "Start Guide");
    }

    private void launchReleaseNotes() {
        AnalyticsRecordsFactory.single((String)Events.RELEASE_NOTES).track();
        this.launch(this.properties.getProperty("RELEASE_NOTES_URL"), "Release Notes");
    }

    private void launchGettingStarted() {
        AnalyticsRecordsFactory.single((String)Events.WELCOME_PAGE_CLICK_GETTING_STARTED).track();
        this.launch("https://developer.mulesoft.com/tutorials-and-howtos/getting-started/hello-mule", "Getting Started");
    }

    private void launchTutorials() {
        this.launch("https://developer.mulesoft.com/tutorials-and-howtos", "Tutorials page");
    }

    private void launch(String url, String error) {
        try {
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
        }
        catch (MalformedURLException | PartInitException e) {
            MuleCorePlugin.logError((String)("Could not launch " + error), (Throwable)e);
        }
    }

    public boolean close() {
        AnalyticsRecordsFactory.single((String)Events.CLOSE_WELCOME_PAGE).track();
        AnalyticsRecordsFactory.single((String)Events.WELCOME_PAGE_SCROLL, (String[])new String[]{"scrollPercentage", this.maxScrolled.toString()}).track();
        this.updateAnalytics();
        return super.close();
    }

    public int open() {
        int open = super.open();
        AnalyticsRecordsFactory.single((String)Events.OPEN_WELCOME_PAGE).track();
        return open;
    }

    static interface WelcomeSize {
        public int calc(int var1, int var2);
    }
}

