/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.osgi.framework.Bundle;

public class MuleUpdateImages {
    private static ImageRegistry registry = new ImageRegistry();

    public static ImageDescriptor getManaged(String path) {
        Path relPath = new Path(path);
        ImageDescriptor desc = registry.getDescriptor(relPath.toString());
        if (desc == null) {
            desc = MuleUpdateImages.create((IPath)relPath);
            registry.put(relPath.toString(), desc);
        }
        return desc;
    }

    public static Image getImage(String path) {
        Path relPath = new Path(path);
        Image image = registry.get(relPath.toString());
        if (image == null) {
            ImageDescriptor desc = MuleUpdateImages.getManaged(path);
            image = desc.createImage();
        }
        return image;
    }

    public static ImageDescriptor create(IPath path) {
        return MuleUpdateImages.createImageDescriptor(MuleUpdatePlugin.getDefault().getBundle(), path, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

