/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.update;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.update.MuleUpdatePlugin;
import org.mule.tooling.update.SaveInstallInformationJob;
import org.mule.tooling.update.welcome.WelcomePageHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CheckUpdateJob
extends Job {
    private Bundle bundle;
    private IPreferenceStore preferenceStore;

    public CheckUpdateJob(Bundle bundle, IPreferenceStore iPreferenceStore) {
        super("Check if updated");
        if (bundle == null || iPreferenceStore == null) {
            throw new IllegalArgumentException((bundle == null ? "bundle" : "preferenceStore") + " cannot be null");
        }
        this.bundle = bundle;
        this.preferenceStore = iPreferenceStore;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Version currentVersion;
        Version storedPluginVersion = MuleUpdatePlugin.getCurrentStoredVersion(this.preferenceStore);
        if (this.updated(storedPluginVersion, currentVersion = this.trimQualifier(this.getCurrentVersion())) || this.isNightlyUpdated()) {
            this.updateVersionsOnPreferenceStore();
            this.saveInstallationInformation();
            this.showWelcomePage();
        }
        return Status.OK_STATUS;
    }

    private void saveInstallationInformation() {
        try {
            SaveInstallInformationJob installInformationJob = new SaveInstallInformationJob(this.bundle, ConfigurationScope.INSTANCE.getNode(this.bundle.getSymbolicName()));
            installInformationJob.schedule();
        }
        catch (Throwable e) {
            MuleCorePlugin.logError((String)"There was a problem saving install information", (Throwable)e);
        }
    }

    private void showWelcomePage() {
        try {
            WelcomePageHandler welcomePage = new WelcomePageHandler();
            welcomePage.execute(null);
        }
        catch (ExecutionException executionException) {
            MuleUpdatePlugin.logError("There was a problem showing the Welcome Page");
        }
    }

    private boolean isNightlyUpdated() {
        if (CoreUtils.getInstallationService((Bundle)this.bundle).isNightlyBuild()) {
            return this.getCurrentVersion().getQualifier().compareTo(MuleUpdatePlugin.getPreviousStoredVersionQualifier(this.preferenceStore)) > 0;
        }
        return false;
    }

    private void updateVersionsOnPreferenceStore() {
        Version version = this.getCurrentVersion();
        this.preferenceStore.setValue("studio_update_previous_plugin_version", MuleUpdatePlugin.getCurrentStoredVersion(this.preferenceStore).toString());
        this.preferenceStore.setValue("studio_update_current_plugin_version", this.trimQualifier(version).toString());
        if (CoreUtils.getInstallationService((Bundle)this.bundle).isNightlyBuild()) {
            this.preferenceStore.setValue("studio_update_previous_plugin_version", MuleUpdatePlugin.getCurrentStoredVersionQualifier(this.preferenceStore));
            this.preferenceStore.setValue("studio_update_current_plugin_version_qualifier", version.getQualifier().toString());
        }
    }

    private Version trimQualifier(Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    private boolean updated(Version storedPluginVersion, Version currentVersion) {
        return currentVersion.compareTo(storedPluginVersion) > 0;
    }

    private Version getCurrentVersion() {
        return this.bundle.getVersion();
    }
}

