/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.oauth.internal.platform;

import java.nio.charset.Charset;
import org.mule.oauth.client.api.builder.ClientCredentialsLocation;

public class OCSSettings {
    private final String platformUrl;
    private final String tokenUrl;
    private final String clientId;
    private final String clientSecret;
    private final Charset encoding;
    private final ClientCredentialsLocation clientCredentialsLocation;
    private final String organizationId;
    private final String apiVersion;

    public OCSSettings(String platformUrl, String tokenUrl, String clientId, String clientSecret, Charset encoding, ClientCredentialsLocation clientCredentialsLocation, String organizationId) {
        this(platformUrl, tokenUrl, clientId, clientSecret, encoding, clientCredentialsLocation, organizationId, null);
    }

    public OCSSettings(String platformUrl, String tokenUrl, String clientId, String clientSecret, Charset encoding, ClientCredentialsLocation clientCredentialsLocation, String organizationId, String apiVersion) {
        this.platformUrl = OCSSettings.sanitizeUrl(platformUrl);
        this.tokenUrl = OCSSettings.sanitizeUrl(tokenUrl);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.encoding = encoding;
        this.clientCredentialsLocation = clientCredentialsLocation;
        this.organizationId = organizationId;
        this.apiVersion = apiVersion;
    }

    public String getPlatformUrl() {
        return this.platformUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public ClientCredentialsLocation getClientCredentialsLocation() {
        return this.clientCredentialsLocation;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    private static String sanitizeUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

