/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.starter;

import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerStarter {
    public static final String MODULE_PATH = "module_path";
    private static Logger logger = LoggerFactory.getLogger(LayerStarter.class);

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-module_path")) continue;
            Path modulePath = Path.of(args[i + 1], new String[0]);
            ModuleFinder finder = ModuleFinder.of(modulePath);
            ModuleLayer parent = ModuleLayer.boot();
            Configuration cf = parent.configuration().resolveAndBind(finder, ModuleFinder.of(new Path[0]), Set.of("munit.remote"));
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            ModuleLayer layer = parent.defineModulesWithManyLoaders(cf, scl);
            LayerStarter.openToModule(layer, "org.mule.runtime.embedded.api", "java.base", Arrays.asList("java.lang", "java.lang.reflect", "java.lang.invoke", "sun.security.provider", "java.nio", "jdk.internal", "sun.nio.ch"));
            LayerStarter.openToModule(layer, "org.mule.runtime.embedded.api", "java.sql", Arrays.asList("java.sql"));
            LayerStarter.openToModule(layer, "org.mule.runtime.embedded.api", "java.naming", Arrays.asList("javax.naming"));
            LayerStarter.openToModule(layer, "org.mule.runtime.embedded.api", "java.management", Arrays.asList("sun.management"));
            LayerStarter.openToModule(layer, "org.mule.runtime.embedded.api", "jdk.management", Arrays.asList("com.sun.management.internal", "com.ibm.lang.management.internal"));
            LayerStarter.openToModule(layer, "org.bouncycastle.fips.core", "java.base", Arrays.asList("sun.security.provider", "sun.security.internal.spec"));
            Class<?> c = layer.findLoader("munit.remote").loadClass("org.mule.munit.remote.RemoteRunner");
            String runConfiguration = "";
            for (int j = 0; j < args.length; ++j) {
                if (!args[j].equals("-run_configuration")) continue;
                runConfiguration = args[j + 1];
            }
            Method m = c.getDeclaredMethod("mainStarter", String.class);
            m.invoke(null, runConfiguration);
        }
    }

    public static void openToModule(ModuleLayer layer, String moduleName, String bootModuleName, List<String> packages) {
        try {
            layer.findModule(moduleName).ifPresent(module -> ModuleLayer.boot().findModule(bootModuleName).ifPresent(bootModule -> {
                for (String pkg : packages) {
                    bootModule.addOpens(pkg, (Module)module);
                }
            }));
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }
}

