/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.preferences;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.ui.contribution.apigateway.Activator;
import org.mule.tooling.ui.contribution.apigateway.client.APIPlatformRestClient;
import org.mule.tooling.ui.contribution.apigateway.client.Me;
import org.mule.tooling.ui.contribution.apigateway.client.RestClientException;
import org.mule.tooling.ui.contribution.apigateway.client.UnauthorizedException;
import org.mule.tooling.ui.contribution.apigateway.preferences.SyncGetResultCallback;

public class ClientCredentialsRetriever {
    private static final String CLIENT_ID_SECRET_INCORRECT = "Your client id and/or secret are not valid. Verify them on your Anypoint Platform account";
    private String clientId;
    private String clientSecret;
    private String apiPlatformUrlValue;
    private String analyticsUrlValue;
    private String organizationName;

    public ClientCredentialsRetriever(String urlValue, String clientId, String clientSecret, String analyticsUrlValue) {
        this.apiPlatformUrlValue = urlValue;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.analyticsUrlValue = analyticsUrlValue;
    }

    public int retrieve(SyncGetResultCallback syncGetResultCallback) {
        try {
            APIPlatformRestClient apiPlatformRestClient = new APIPlatformRestClient(this.apiPlatformUrlValue, this.analyticsUrlValue, this.clientId, this.clientSecret);
            Me me = apiPlatformRestClient.me();
            this.organizationName = me.getUser().getOrganization().getName();
            syncGetResultCallback.finished(0);
            return 0;
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.ui.contribution.apigateway", "There was an error while trying to get client credentials.", (Throwable)e));
            syncGetResultCallback.finished(-1);
            return -1;
        }
        catch (UnauthorizedException e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.open((int)1, (Shell)shell, (String)"Authorization was not successful", (String)CLIENT_ID_SECRET_INCORRECT, (int)0);
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.ui.contribution.apigateway", CLIENT_ID_SECRET_INCORRECT, (Throwable)((Object)e)));
            syncGetResultCallback.finished(-1);
            return -1;
        }
        catch (RestClientException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.ui.contribution.apigateway", "A comunication error has happenned", (Throwable)((Object)e)));
            syncGetResultCallback.finished(-1);
            return -1;
        }
        catch (URISyntaxException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.ui.contribution.apigateway", "The URI syntax is not valid or is erroneous", (Throwable)e));
            syncGetResultCallback.finished(-1);
            return -1;
        }
        catch (Exception exception) {
            syncGetResultCallback.finished(-1);
            return -1;
        }
    }

    public String getOutput() {
        return !StringUtils.isEmpty((String)this.organizationName) ? this.organizationName : "Not available";
    }
}

