/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.ui.contribution.apigateway.Activator;
import org.mule.tooling.ui.contribution.apigateway.preferences.ClientCredentialsRetriever;
import org.mule.tooling.ui.contribution.apigateway.preferences.SyncGetResultCallback;

public class ClientCredentialsComponent {
    private static final String VALIDATE_ENVIRONMENT_CREDENTIALS_LABEL = "Validate Environment Credentials";
    private static final String ENVIRONMENT_CREDENTIALS_BUTTON_TEXT = "Validate";
    private static final Point STATUS_LABEL_HINT = new Point(16, 16);
    private Button validateCredentialsButton;
    private Label statusLabel;
    private Label clientCredentialsResultLabel;
    private boolean visibleByDefault;
    private String apiPlatformUrl;
    private String clientId;
    private String clientSecret;
    private String analyticsUrlValue;

    public ClientCredentialsComponent(Composite parent, Point span, boolean visibleByDefault) {
        this.visibleByDefault = visibleByDefault;
        Composite parentComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(3).equalWidth(false).applyTo(parentComposite);
        GridDataFactory.fillDefaults().span(span).grab(true, true).applyTo((Control)parentComposite);
        Label validateCredentialsLabel = new Label(parentComposite, 64);
        validateCredentialsLabel.setText(VALIDATE_ENVIRONMENT_CREDENTIALS_LABEL);
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(1, 1).applyTo((Control)validateCredentialsLabel);
        this.createGetClientCredentialsButton(parentComposite);
        this.statusLabel = new Label(parentComposite, 0);
        GridDataFactory.swtDefaults().align(1, 4).hint(STATUS_LABEL_HINT).applyTo((Control)this.statusLabel);
        this.createClientCredentialsResultLabel(parentComposite);
    }

    public ClientCredentialsComponent(Composite parent, Point span) {
        this(parent, span, false);
    }

    private void createGetClientCredentialsButton(Composite composite) {
        this.validateCredentialsButton = new Button(composite, 0);
        this.validateCredentialsButton.setText(ENVIRONMENT_CREDENTIALS_BUTTON_TEXT);
        this.validateCredentialsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientCredentialsComponent.this.retrieveCredentials();
            }
        });
        GridDataFactory.swtDefaults().align(1, 0x1000000).applyTo((Control)this.validateCredentialsButton);
    }

    private void createClientCredentialsResultLabel(Composite composite) {
        this.clientCredentialsResultLabel = new Label(composite, 64);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).align(4, 0x1000000).applyTo((Control)this.clientCredentialsResultLabel);
        this.clientCredentialsResultLabel.setVisible(this.visibleByDefault);
    }

    protected void retrieveCredentials() {
        this.statusLabel.setImage(Activator.getDefault().getImageRegistry().get("BUSY"));
        this.emptyDisplayEventsQueue();
        final ClientCredentialsRetriever clientCredentialsRetriever = new ClientCredentialsRetriever(this.apiPlatformUrl, this.clientId, this.clientSecret, this.analyticsUrlValue);
        clientCredentialsRetriever.retrieve(new SyncGetResultCallback(){

            @Override
            public void finished(final int result) {
                super.finished(result);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ClientCredentialsComponent.this.onGetCredentialsFinished(clientCredentialsRetriever, result);
                    }
                });
            }
        });
    }

    void onGetCredentialsFinished(ClientCredentialsRetriever clientCredentialsRetriever, int result) {
        Image statusImage = result == 0 ? Activator.getDefault().getImageRegistry().get("OK_IMAGE") : Activator.getDefault().getImageRegistry().get("NOT_OK_IMAGE");
        this.statusLabel.setImage(statusImage);
        this.statusLabel.update();
        this.clientCredentialsResultLabel.setText("Organization Name: " + clientCredentialsRetriever.getOutput());
        this.clientCredentialsResultLabel.setVisible(true);
    }

    private void emptyDisplayEventsQueue() {
        Display currentDisplay = Display.getCurrent();
        Display display = currentDisplay == null ? Display.getDefault() : currentDisplay;
        int fuse = 100;
        while (display.readAndDispatch() && --fuse > 0) {
        }
        display.sleep();
    }

    public void setEnabled(boolean enabled) {
        this.validateCredentialsButton.setEnabled(enabled);
        if (!enabled) {
            this.clientCredentialsResultLabel.setVisible(this.visibleByDefault);
            this.clientCredentialsResultLabel.setText("");
            this.statusLabel.setImage(null);
        }
    }

    public void setClientParameters(String apiPlatformUrl, String analyticsUrlValue, String clientId, String clientSecret) {
        this.apiPlatformUrl = apiPlatformUrl;
        this.analyticsUrlValue = analyticsUrlValue;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }
}

