/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthenticationEventTypes;
import org.mule.tooling.core.auth.IOnPremStatusChanged;
import org.mule.tooling.core.auth.IUpdateRegionServicesUrlListener;
import org.mule.tooling.ui.contribution.apigateway.Activator;
import org.mule.tooling.ui.contribution.apigateway.preferences.APIGatewayPreferences;
import org.mule.tooling.ui.contribution.apigateway.preferences.ClientCredentialsComponent;
import org.mule.tooling.ui.modules.core.widgets.editors.UrlFieldEditor;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class AnypointPlatformForAPIsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String URIS_LABEL = "URIs";
    private static final String CLIENT_SECRET_LABEL = "Client Secret";
    private static final String CLIENT_ID_LABEL = "Client Id";
    private static final String API_PLATFORM_SERVER_URI_LABEL = "API Platform URI";
    private static final String ANALYTICS_SERVER_URI_LABEL = "Analytics URI";
    private static final String CLICK_TO_SEE_DOCUMENTATION = "See the <a>Documentation</a> to configure this property";
    private static final String GATEKEEPER_LABEL = "Gatekeeper Settings";
    private StringFieldEditor clientSecretFieldEditor;
    private StringFieldEditor clientIdFieldEditor;
    private UrlFieldEditor apiPlatformUrlFieldEditor;
    private UrlFieldEditor analyticsUrlFieldEditor;
    private Group urisGroup;
    private Group clientCredentialsGroup;
    private Group validateCredentialsGroup;
    private Group gatekeeperGroup;
    private ComboFieldEditor gatekeeperCombo;
    private ClientCredentialsComponent clientCredentialsComponent;
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private BooleanFieldEditor overrideUrlsFieldEditor;
    private APIGatewayPreferences preferences;

    public AnypointPlatformForAPIsPreferencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.setPreferenceStore(preferenceStore);
        this.preferences = new APIGatewayPreferences(preferenceStore);
        this.setDescription("Anypoint Platform for APIs pairing properties");
    }

    protected void createFieldEditors() {
        this.urisGroup = new Group(this.getFieldEditorParent(), 32);
        this.urisGroup.setText(URIS_LABEL);
        this.apiPlatformUrlFieldEditor = new UrlFieldEditor("anypoint.platform.base_uri", API_PLATFORM_SERVER_URI_LABEL, (Composite)this.urisGroup);
        this.initURIFieldEditor(this.urisGroup, this.apiPlatformUrlFieldEditor);
        this.analyticsUrlFieldEditor = new UrlFieldEditor("anypoint.platform.analytics_base_uri", ANALYTICS_SERVER_URI_LABEL, (Composite)this.urisGroup);
        this.initURIFieldEditor(this.urisGroup, this.analyticsUrlFieldEditor);
        this.overrideUrlsFieldEditor = new BooleanFieldEditor("anypoint.platform.override_urls", "Override url configuration", (Composite)this.urisGroup);
        this.addField((FieldEditor)this.overrideUrlsFieldEditor);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)this.urisGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.urisGroup);
        this.clientCredentialsGroup = new Group(this.getFieldEditorParent(), 32);
        this.clientCredentialsGroup.setText("Environment Credentials");
        this.clientIdFieldEditor = new StringFieldEditor("anypoint.platform.client_id", CLIENT_ID_LABEL, (Composite)this.clientCredentialsGroup);
        this.clientIdFieldEditor.getTextControl((Composite)this.clientCredentialsGroup).addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AnypointPlatformForAPIsPreferencesPage.this.valueChanged(AnypointPlatformForAPIsPreferencesPage.this.isValid());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.clientSecretFieldEditor = new StringFieldEditor("anypoint.platform.client_secret", CLIENT_SECRET_LABEL, (Composite)this.clientCredentialsGroup){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                this.getTextControl().setEchoChar('*');
            }
        };
        this.clientSecretFieldEditor.getTextControl((Composite)this.clientCredentialsGroup).addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AnypointPlatformForAPIsPreferencesPage.this.valueChanged(AnypointPlatformForAPIsPreferencesPage.this.isValid());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)this.clientCredentialsGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.clientCredentialsGroup);
        this.validateCredentialsGroup = new Group(this.getFieldEditorParent(), 32);
        GridLayoutFactory.fillDefaults().margins(5, 5).generateLayout((Composite)this.validateCredentialsGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.validateCredentialsGroup);
        this.clientCredentialsComponent = new ClientCredentialsComponent((Composite)this.validateCredentialsGroup, new Point(3, -1));
        this.gatekeeperGroup = new Group(this.getFieldEditorParent(), 32);
        GridLayoutFactory.fillDefaults().margins(5, 5).generateLayout((Composite)this.gatekeeperGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.gatekeeperGroup);
        this.gatekeeperGroup.setText(GATEKEEPER_LABEL);
        String[][] namesAndValues = new String[][]{{"Disabled", "disabled"}, {"Flexible", "flexible"}, {"Strict", "strict"}};
        this.gatekeeperCombo = new ComboFieldEditor("anypoint.platform.gatekeeper", "Configure the Gatekeeper property with a security level:", namesAndValues, (Composite)this.gatekeeperGroup);
        Link link = new Link((Composite)this.gatekeeperGroup, 0);
        link.setFont(this.gatekeeperGroup.getFont());
        link.setText(CLICK_TO_SEE_DOCUMENTATION);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Program.launch((String)"https://docs.mulesoft.com/mule-gateway/mule-gateway-gatekeeper");
                }
                catch (Exception exception) {}
            }
        });
        this.addField((FieldEditor)this.clientIdFieldEditor);
        this.addField((FieldEditor)this.clientSecretFieldEditor);
        this.addField((FieldEditor)this.gatekeeperCombo);
        this.updateUrlsState(this.getPreferenceStore().getBoolean("anypoint.platform.override_urls"));
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), AuthenticationEventTypes.ON_ONPREM_CHANGED, (IEventHandler)new IOnPremStatusChanged(){

            public void onCurrentUrlChanged(boolean activated, String url) {
                if (activated) {
                    AnypointPlatformForAPIsPreferencesPage.this.preferences.loadUrlsFromPreferenceStore();
                    AnypointPlatformForAPIsPreferencesPage.this.loadFieldEditors();
                    AnypointPlatformForAPIsPreferencesPage.this.valueChanged(AnypointPlatformForAPIsPreferencesPage.this.isValid());
                }
            }
        });
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), AuthenticationEventTypes.UPDATE_REGION_URL, (IEventHandler)new IUpdateRegionServicesUrlListener(){

            public void onUpdateRegionServiceUrl() {
                AnypointPlatformForAPIsPreferencesPage.this.preferences.loadUrlsFromPreferenceStore();
                AnypointPlatformForAPIsPreferencesPage.this.loadFieldEditors();
                AnypointPlatformForAPIsPreferencesPage.this.valueChanged(AnypointPlatformForAPIsPreferencesPage.this.isValid());
            }
        });
    }

    private void initURIFieldEditor(Group urisGroup, UrlFieldEditor fieldEditor) {
        fieldEditor.getTextControl((Composite)urisGroup).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AnypointPlatformForAPIsPreferencesPage.this.valueChanged(AnypointPlatformForAPIsPreferencesPage.this.isValid());
            }
        });
        this.addField((FieldEditor)fieldEditor);
    }

    protected void initialize() {
        super.initialize();
        this.valueChanged(this.isValid());
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.overrideUrlsFieldEditor)) {
            boolean overrideValues = (Boolean)event.getNewValue();
            this.updateUrlsState(overrideValues);
            this.preferences.loadUrls(overrideValues);
            this.loadFieldEditors();
            this.valueChanged(this.isValid());
        }
    }

    private void valueChanged(boolean valid) {
        this.clientCredentialsComponent.setEnabled(valid);
        if (valid) {
            String clientId = this.clientIdFieldEditor.getTextControl((Composite)this.clientCredentialsGroup).getText();
            String clientSecret = this.clientSecretFieldEditor.getTextControl((Composite)this.clientCredentialsGroup).getText();
            String apiPlatformUrl = this.apiPlatformUrlFieldEditor.getTextControl((Composite)this.urisGroup).getText();
            String analyticsUrlValue = this.analyticsUrlFieldEditor.getTextControl((Composite)this.urisGroup).getText();
            this.clientCredentialsComponent.setClientParameters(apiPlatformUrl, analyticsUrlValue, clientId, clientSecret);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateUrlsState(false);
    }

    private void updateUrlsState(boolean isUsingCustomUrl) {
        this.analyticsUrlFieldEditor.setEnabled(isUsingCustomUrl, (Composite)this.urisGroup);
        this.apiPlatformUrlFieldEditor.setEnabled(isUsingCustomUrl, (Composite)this.urisGroup);
    }

    private void loadFieldEditors() {
        this.apiPlatformUrlFieldEditor.load();
        this.analyticsUrlFieldEditor.load();
    }

    public void dispose() {
        this.eventBusHelper.unregister();
    }
}

