/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.contribution.apigateway.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.ui.contribution.apigateway.Activator;

public class APIGatewayPreferences {
    public static final String API_PLATFORM_SERVER_URI = "anypoint.platform.base_uri";
    public static final String ANALYTICS_SERVER_URI = "anypoint.platform.analytics_base_uri";
    public static final String PLATFORM_DEFAULT_URI = "https://anypoint.mulesoft.com/";
    public static final String ANALYTICS_DEFAULT_URI = "https://analytics-ingest.anypoint.mulesoft.com";
    public static final String API_MANAGER_CLIENT_ID = "anypoint.platform.client_id";
    public static final String API_MANAGER_CLIENT_SECRET = "anypoint.platform.client_secret";
    public static final String OVERRIDE_URLS = "anypoint.platform.override_urls";
    public static final String API_GATEWAY_PLATFORM_GATEKEEPER = "anypoint.platform.gatekeeper";
    private IPreferenceStore preferenceStore;

    public APIGatewayPreferences(IPreferenceStore prefStore) {
        this.preferenceStore = prefStore;
        this.loadUrlsFromPreferenceStore();
    }

    public APIGatewayPreferences() {
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
    }

    public String getPlatformApiClientId() {
        return this.preferenceStore.getString(API_MANAGER_CLIENT_ID);
    }

    public String getPlatformApiClientSecret() {
        return this.preferenceStore.getString(API_MANAGER_CLIENT_SECRET);
    }

    public String getPlatformUri() {
        if (this.areUrlsOverriden().booleanValue()) {
            return this.preferenceStore.getString(API_PLATFORM_SERVER_URI);
        }
        return PlatformUrls.getActiveGatewayPlatformUrl();
    }

    public String getPlatformAnalyticsUri() {
        if (this.areUrlsOverriden().booleanValue()) {
            return this.preferenceStore.getString(ANALYTICS_SERVER_URI);
        }
        return PlatformUrls.getActiveGatewayAnalyticsUrl();
    }

    public Boolean areUrlsOverriden() {
        return this.preferenceStore.getBoolean(OVERRIDE_URLS);
    }

    public void loadUrlsFromPreferenceStore() {
        this.loadUrls(this.areUrlsOverriden());
    }

    public void loadUrls(boolean overrideUrls) {
        if (!overrideUrls) {
            this.preferenceStore.setValue(API_PLATFORM_SERVER_URI, PlatformUrls.getActiveGatewayPlatformUrl());
            this.preferenceStore.setValue(ANALYTICS_SERVER_URI, PlatformUrls.getActiveGatewayAnalyticsUrl());
        }
    }

    public String getApiGatewayPlatformGatekeeper() {
        return this.preferenceStore.getString(API_GATEWAY_PLATFORM_GATEKEEPER);
    }
}

